/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.rollingupgrades;

import javax.management.ObjectName;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.server.test.category.RollingUpgrades;
import org.infinispan.server.test.rollingupgrades.AbstractHotRodRollingUpgradesIT;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={RollingUpgrades.class})
public class HotRodRollingUpgradesIT
extends AbstractHotRodRollingUpgradesIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHotRodRollingUpgradesDiffVersions() throws Exception {
        int managementPortServer1 = 9990;
        int managementPortServer2 = 10099;
        try {
            if (!Boolean.parseBoolean(System.getProperty("start.jboss.as.manually"))) {
                this.controller.start("hotrod-rolling-upgrade-2-old");
                managementPortServer2 = 10090;
            }
            ConfigurationBuilder builder = new ConfigurationBuilder();
            builder.addServer().host("127.0.0.1").port(11322).version(ProtocolVersion.PROTOCOL_VERSION_12);
            RemoteCacheManager rcm = new RemoteCacheManager(builder.build());
            RemoteCache c2 = rcm.getCache("default");
            c2.put((Object)"key1", (Object)"value1");
            Assert.assertEquals((Object)"value1", (Object)c2.get((Object)"key1"));
            for (int i = 0; i < 50; ++i) {
                c2.put((Object)("keyLoad" + i), (Object)("valueLoad" + i));
            }
            this.controller.start("hotrod-rolling-upgrade-1");
            RemoteInfinispanMBeans s1 = this.createRemotes("hotrod-rolling-upgrade-1", "local", "default");
            RemoteCache<Object, Object> c1 = this.createCache(s1);
            Assert.assertEquals((String)"Can't access entries stored in source node (target's RemoteCacheStore).", (Object)"value1", (Object)c1.get((Object)"key1"));
            ObjectName rollMan = new ObjectName("jboss.datagrid-infinispan:type=Cache,name=\"default(local)\",manager=\"local\",component=RollingUpgradeManager");
            MBeanServerConnectionProvider provider1 = new MBeanServerConnectionProvider(s1.server.getHotrodEndpoint().getInetAddress().getHostName(), 9990);
            this.invokeOperation(provider1, rollMan.toString(), "synchronizeData", new Object[]{"hotrod"}, new String[]{"java.lang.String"});
            this.invokeOperation(provider1, rollMan.toString(), "disconnectSource", new Object[]{"hotrod"}, new String[]{"java.lang.String"});
            c2.put((Object)"disconnected", (Object)"source");
            Assert.assertEquals((String)"Can't obtain value from cache2 (source node).", (Object)"source", (Object)c2.get((Object)"disconnected"));
            Assert.assertNull((String)"Source node entries should NOT be accessible from target node (after RCS disconnection)", (Object)c1.get((Object)"disconnected"));
            Assert.assertEquals((String)"Entry was not successfully migrated.", (Object)"value1", (Object)c1.get((Object)"key1"));
            for (int i = 0; i < 50; ++i) {
                Assert.assertEquals((String)"Entry was not successfully migrated.", (Object)("valueLoad" + i), (Object)c1.get((Object)("keyLoad" + i)));
            }
        }
        finally {
            if (this.controller.isStarted("hotrod-rolling-upgrade-1")) {
                this.controller.stop("hotrod-rolling-upgrade-1");
            }
            if (this.controller.isStarted("hotrod-rolling-upgrade-2-old")) {
                this.controller.stop("hotrod-rolling-upgrade-2-old");
            }
        }
    }
}

