/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.server.test.category.Queries;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.infinispan.server.test.util.security.SecurityConfigurationHelper;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@Category(value={Queries.class})
@RunWith(value=Arquillian.class)
@WithRunningServer(value={@RunningServer(name="remote-query-security")})
public class RemoteQuerySecurityIT {
    @InfinispanResource(value="remote-query-security")
    protected RemoteInfinispanServer server;
    private RemoteCacheManagerFactory rcmFactory;
    private final Map<String, RemoteCacheManager> remoteCacheManagers = new HashMap<String, RemoteCacheManager>();
    private static final String TEST_CACHE_INDEXED = "test_cache_indexed";
    private static final String TEST_CACHE_NOT_INDEXED = "test_cache_not_indexed";
    private static final String TEST_SERVER_NAME = "node2";
    private static final String SASL_MECH = "PLAIN";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.rcmFactory = new RemoteCacheManagerFactory();
        this.remoteCacheManagers.put("admin", this.rcmFactory.createManager(this.getClientConfigBuilderForUser("admin", "strongPassword")));
        this.remoteCacheManagers.put("writer", this.rcmFactory.createManager(this.getClientConfigBuilderForUser("writer", "somePassword")));
        this.remoteCacheManagers.put("reader", this.rcmFactory.createManager(this.getClientConfigBuilderForUser("reader", "password")));
        this.remoteCacheManagers.put("supervisor", this.rcmFactory.createManager(this.getClientConfigBuilderForUser("supervisor", "lessStrongPassword")));
        RemoteCache metadataCache = this.remoteCacheManagers.get("admin").getCache("___protobuf_metadata");
        String proto = Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)this.getClass().getClassLoader());
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)proto);
        Assert.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        MarshallerRegistration.registerMarshallers((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManagers.get("admin")));
        MarshallerRegistration.registerMarshallers((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManagers.get("reader")));
        MarshallerRegistration.registerMarshallers((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManagers.get("writer")));
        MarshallerRegistration.registerMarshallers((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManagers.get("supervisor")));
        User user = new User();
        user.setId(1);
        user.setName("Tom");
        user.setSurname("Cat");
        user.setGender(User.Gender.MALE);
        user.setAccountIds(Collections.singleton(12));
        this.remoteCacheManagers.get("admin").getCache(TEST_CACHE_INDEXED).put((Object)1, (Object)user);
        this.remoteCacheManagers.get("admin").getCache(TEST_CACHE_NOT_INDEXED).put((Object)1, (Object)user);
    }

    private ConfigurationBuilder getClientConfigBuilderForUser(String login, String password) {
        return new SecurityConfigurationHelper(SASL_MECH).forIspnServer(this.server).withServerName(TEST_SERVER_NAME).forCredentials(login, password).marshaller((Marshaller)new ProtoStreamMarshaller());
    }

    @After
    public void tearDown() {
        if (this.rcmFactory != null) {
            this.rcmFactory.stopManagers();
        }
        this.rcmFactory = null;
    }

    @Test
    public void testReaderQueryIndexed() {
        this.expectedException.expect(HotRodClientException.class);
        this.expectedException.expectMessage("Unauthorized access");
        this.execQuery("reader", TEST_CACHE_INDEXED);
    }

    @Test
    public void testReaderQueryNotIndexed() {
        this.expectedException.expect(HotRodClientException.class);
        this.expectedException.expectMessage("Unauthorized access");
        this.execQuery("reader", TEST_CACHE_NOT_INDEXED);
    }

    @Test
    public void testWriterQueryIndexed() {
        this.expectedException.expect(HotRodClientException.class);
        this.expectedException.expectMessage("Unauthorized access");
        this.execQuery("writer", TEST_CACHE_INDEXED);
    }

    @Test
    public void testWriterQueryNotIndexed() {
        this.expectedException.expect(HotRodClientException.class);
        this.expectedException.expectMessage("Unauthorized access");
        this.execQuery("writer", TEST_CACHE_NOT_INDEXED);
    }

    @Test
    public void testSupervisorQueryIndexed() {
        this.execQuery("supervisor", TEST_CACHE_INDEXED);
    }

    @Test
    public void testSupervisorQueryNotIndexed() {
        this.execQuery("supervisor", TEST_CACHE_NOT_INDEXED);
    }

    @Test
    public void testAdminQueryIndexed() {
        this.execQuery("admin", TEST_CACHE_INDEXED);
    }

    @Test
    public void testAdminQueryNotIndexed() {
        this.execQuery("admin", TEST_CACHE_NOT_INDEXED);
    }

    private void execQuery(String userLogin, String cacheName) {
        RemoteCache cache = this.remoteCacheManagers.get(userLogin).getCache(cacheName);
        QueryFactory qf = Search.getQueryFactory((RemoteCache)cache);
        Query query = qf.from(User.class).having("name").eq((Object)"Tom").build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(User.class, ((User)list.get(0)).getClass());
    }
}

