/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class RemoteQueryNearCacheIT {
    private static final String CONTAINER_NAME = "remote-query-minimal";
    @InfinispanResource(value="remote-query-minimal")
    protected RemoteInfinispanServer server;
    private RemoteCache<Integer, User> remoteCache;

    @Before
    public void setUp() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("127.0.0.1").marshaller((Marshaller)new ProtoStreamMarshaller()).nearCache().mode(NearCacheMode.INVALIDATED).cacheNamePattern("indexed").maxEntries(10);
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(builder.build());
        this.remoteCache = remoteCacheManager.getCache("indexed");
        RemoteCache metadataCache = remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)this.getClass().getClassLoader()));
        Assert.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        MarshallerRegistration.registerMarshallers((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)remoteCacheManager));
    }

    @After
    public void tearDown() {
        if (this.remoteCache != null) {
            this.remoteCache.clear();
            this.remoteCache.getRemoteCacheManager().stop();
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="remote-query-minimal")})
    public void testReplaceValue() {
        User user = new User();
        user.setId(1);
        user.setName("John");
        user.setSurname("Doe");
        user.setGender(User.Gender.MALE);
        this.remoteCache.put((Object)1, (Object)user);
        this.remoteCache.replace((Object)1, (Object)user);
        Assert.assertNotNull((Object)this.remoteCache.get((Object)1));
    }
}

