/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.protostream.sampledomain.Address;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.query.dsl.FilterConditionContextQueryBuilder;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.server.test.category.Queries;
import org.infinispan.server.test.query.RemoteQueryBaseIT;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@Category(value={Queries.class})
@RunWith(value=Arquillian.class)
public class RemoteQueryIT
extends RemoteQueryBaseIT {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @InfinispanResource(value="remote-query-1")
    protected RemoteInfinispanServer server;

    public RemoteQueryIT() {
        super("clustered", "localtestcache");
    }

    protected RemoteQueryIT(String cacheContainerName, String cacheName) {
        super(cacheContainerName, cacheName);
    }

    @Override
    protected RemoteInfinispanServer getServer() {
        return this.server;
    }

    @Test
    public void testAttributeQuery() {
        this.remoteCache.put((Object)1, (Object)this.createUser1());
        this.remoteCache.put((Object)2, (Object)this.createUser2());
        User fromCache = (User)this.remoteCache.get((Object)1);
        this.assertUser1(fromCache);
        QueryFactory qf = Search.getQueryFactory((RemoteCache)this.remoteCache);
        Query query = qf.from(User.class).having("name").eq((Object)"Tom").build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(User.class, ((User)list.get(0)).getClass());
        this.assertUser1((User)list.get(0));
    }

    @Test
    public void testEmbeddedAttributeQuery() {
        this.remoteCache.put((Object)1, (Object)this.createUser1());
        this.remoteCache.put((Object)2, (Object)this.createUser2());
        QueryFactory qf = Search.getQueryFactory((RemoteCache)this.remoteCache);
        Query query = qf.from(User.class).having("addresses.postCode").eq((Object)"1234").build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(User.class, ((User)list.get(0)).getClass());
        this.assertUser1((User)list.get(0));
    }

    @Test
    public void testProjections() {
        this.remoteCache.put((Object)1, (Object)this.createUser1());
        this.remoteCache.put((Object)2, (Object)this.createUser2());
        User fromCache = (User)this.remoteCache.get((Object)1);
        this.assertUser1(fromCache);
        QueryFactory qf = Search.getQueryFactory((RemoteCache)this.remoteCache);
        Query query = qf.from(User.class).select(new String[]{"name", "surname"}).having("name").eq((Object)"Tom").build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(Object[].class, ((Object[])list.get(0)).getClass());
        Assert.assertEquals((Object)"Tom", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Cat", (Object)((Object[])list.get(0))[1]);
    }

    @Test
    public void testUninverting() {
        this.remoteCache.put((Object)1, (Object)this.createUser1());
        this.remoteCache.put((Object)2, (Object)this.createUser2());
        QueryFactory qf = Search.getQueryFactory((RemoteCache)this.remoteCache);
        Query query = qf.from(User.class).having("name").eq((Object)"John").orderBy("id").build();
        Assert.assertEquals((long)0L, (long)query.list().size());
    }

    @Test
    public void testIteratorWithQuery() {
        this.remoteCache.put((Object)1, (Object)this.createUser1());
        this.remoteCache.put((Object)2, (Object)this.createUser2());
        QueryFactory qf = Search.getQueryFactory((RemoteCache)this.remoteCache);
        Query simpleQuery = qf.from(User.class).having("name").eq((Object)"Tom").build();
        ArrayList<Object> entries = new ArrayList<Object>(1);
        try (CloseableIterator iter = this.remoteCache.retrieveEntriesByQuery(simpleQuery, null, 3);){
            while (iter.hasNext()) {
                entries.add(iter.next());
            }
        }
        Assert.assertEquals((long)1L, (long)entries.size());
        Assert.assertEquals((Object)"Cat", (Object)((User)((Map.Entry)entries.get(0)).getValue()).getSurname());
    }

    @Test
    public void testIteratorWithQueryAndProjections() {
        this.remoteCache.put((Object)1, (Object)this.createUser1());
        this.remoteCache.put((Object)2, (Object)this.createUser2());
        QueryFactory qf = Search.getQueryFactory((RemoteCache)this.remoteCache);
        Query simpleQuery = qf.from(User.class).select(new String[]{"surname", "name"}).having("name").eq((Object)"Tom").build();
        ArrayList<Object> entries = new ArrayList<Object>(1);
        try (CloseableIterator iter = this.remoteCache.retrieveEntriesByQuery(simpleQuery, null, 3);){
            while (iter.hasNext()) {
                entries.add(iter.next());
            }
        }
        Assert.assertEquals((long)1L, (long)entries.size());
        Object[] projections = (Object[])((Map.Entry)entries.get(0)).getValue();
        Assert.assertEquals((Object)"Cat", (Object)projections[0]);
        Assert.assertEquals((Object)"Tom", (Object)projections[1]);
    }

    @Test
    public void testQueryViaRest() throws IOException {
        this.remoteCache.put((Object)1, (Object)this.createUser1());
        this.remoteCache.put((Object)2, (Object)this.createUser2());
        String query = "from sample_bank_account.User where name='Adrian'";
        String searchURI = "http://localhost:8080/rest/" + this.cacheName + "?action=search&query=" + URLEncoder.encode(query, "UTF-8");
        HttpGet httpget = new HttpGet(searchURI);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);){
            HttpEntity entity = response.getEntity();
            JsonNode results = new ObjectMapper().readTree(entity.getContent());
            Assert.assertEquals((long)1L, (long)results.get("total_results").asInt());
            EntityUtils.consume((HttpEntity)entity);
        }
    }

    @Test
    public void testManyInClauses() {
        this.remoteCache.put((Object)1, (Object)this.createUser1());
        this.remoteCache.put((Object)2, (Object)this.createUser2());
        User fromCache = (User)this.remoteCache.get((Object)1);
        this.assertUser1(fromCache);
        QueryFactory qf = Search.getQueryFactory((RemoteCache)this.remoteCache);
        HashSet<String> values = new HashSet<String>();
        values.add("Tom");
        for (int i = 0; i < 1024; ++i) {
            values.add("test" + i);
        }
        FilterConditionContextQueryBuilder qb = qf.from(User.class).having("name").in(values);
        List list = qb.build().list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(User.class, ((User)list.get(0)).getClass());
        this.assertUser1((User)list.get(0));
    }

    @Test
    public void testWayTooManyInClauses() {
        this.expectedException.expect(HotRodClientException.class);
        this.expectedException.expectMessage("org.apache.lucene.search.BooleanQuery$TooManyClauses: maxClauseCount is set to 1025");
        HashSet<String> values = new HashSet<String>();
        for (int i = 0; i < 1026; ++i) {
            values.add("test" + i);
        }
        QueryFactory qf = Search.getQueryFactory((RemoteCache)this.remoteCache);
        FilterConditionContextQueryBuilder qb = qf.from(User.class).having("name").in(values);
        qb.build().list();
    }

    private User createUser1() {
        User user = new User();
        user.setId(1);
        user.setName("Tom");
        user.setSurname("Cat");
        user.setGender(User.Gender.MALE);
        user.setAccountIds(Collections.singleton(12));
        Address address = new Address();
        address.setStreet("Dark Alley");
        address.setPostCode("1234");
        user.setAddresses(Collections.singletonList(address));
        return user;
    }

    private User createUser2() {
        User user = new User();
        user.setId(2);
        user.setName("Adrian");
        user.setSurname("Nistor");
        user.setGender(User.Gender.MALE);
        Address address = new Address();
        address.setStreet("Old Street");
        address.setPostCode("XYZ");
        user.setAddresses(Collections.singletonList(address));
        return user;
    }

    private void assertUser1(User user) {
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((long)1L, (long)user.getId());
        Assert.assertEquals((Object)"Tom", (Object)user.getName());
        Assert.assertEquals((Object)"Cat", (Object)user.getSurname());
        Assert.assertEquals((Object)User.Gender.MALE, (Object)user.getGender());
        Assert.assertNotNull((Object)user.getAccountIds());
        Assert.assertEquals((long)1L, (long)user.getAccountIds().size());
        Assert.assertTrue((boolean)user.getAccountIds().contains(12));
        Assert.assertNotNull((Object)user.getAddresses());
        Assert.assertEquals((long)1L, (long)user.getAddresses().size());
        Assert.assertEquals((Object)"Dark Alley", (Object)((Address)user.getAddresses().get(0)).getStreet());
        Assert.assertEquals((Object)"1234", (Object)((Address)user.getAddresses().get(0)).getPostCode());
    }
}

