/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.infinispan.server.test.category.Queries;
import org.infinispan.server.test.query.RemoteQueryIT;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Category(value={Queries.class})
@RunWith(value=Arquillian.class)
public class RemoteQueryDMRRegisterIT
extends RemoteQueryIT {
    @Override
    @Before
    public void setUp() throws Exception {
        this.rcmFactory = new RemoteCacheManagerFactory();
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host(this.getServer().getHotrodEndpoint().getInetAddress().getHostName()).port(this.getServer().getHotrodEndpoint().getPort()).marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = this.rcmFactory.createManager(clientBuilder);
        this.remoteCache = this.remoteCacheManager.getCache(this.cacheName);
        ModelNode nameList = new ModelNode().add("/sample_bank_account/bank.proto");
        ModelNode urlList = new ModelNode().add(this.getClass().getResource("/sample_bank_account/bank.proto").toString());
        ModelControllerClient client = ModelControllerClient.Factory.create((String)this.getServer().getHotrodEndpoint().getInetAddress().getHostName(), (int)9990);
        ModelNode addProtobufFileOp = this.getOperation("upload-proto-schemas", nameList, urlList);
        ModelNode result = client.execute(addProtobufFileOp);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        client.close();
        RemoteCache metadataCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        Assert.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        MarshallerRegistration.registerMarshallers((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager));
    }

    private ModelNode getOperation(String operationName, ModelNode nameList, ModelNode urlList) {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"datagrid-infinispan")}).append("cache-container", this.cacheContainerName);
        ModelNode op = new ModelNode();
        op.get("operation").set(operationName);
        op.get("address").set(address.toModelNode());
        op.get("file-names").set(nameList);
        op.get("file-urls").set(urlList);
        return op;
    }
}

