/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.jboss.AbstractJBossMarshaller;
import org.infinispan.commons.marshall.jboss.DefaultContextClassResolver;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.server.test.category.Queries;
import org.infinispan.server.test.query.TestEntity;
import org.infinispan.server.test.util.ITestUtils;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.marshalling.ClassResolver;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Queries.class})
public class RemoteQueryCompatModeIT {
    private static final Set<File> deployments = new HashSet<File>();
    private static RemoteCacheManager remoteCacheManager;
    @InfinispanResource(value="custom-compat-marshaller")
    RemoteInfinispanServer server1;

    @BeforeClass
    public static void before() {
        JavaArchive entityArchive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestEntity.class})).add((Asset)new StringAsset("Dependencies: org.hibernate.search.engine"), "META-INF/MANIFEST.MF");
        JavaArchive marshallerArchive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{CustomCompatModeMarshaller.class})).add((Asset)new StringAsset("Dependencies: org.jboss.marshalling, org.infinispan.commons, org.infinispan.remote-query.client, deployment.custom-test-entity.jar"), "META-INF/MANIFEST.MF")).addAsServiceProvider(Marshaller.class, new Class[]{CustomCompatModeMarshaller.class});
        File deployment1 = new File(System.getProperty("server1.dist"), "/standalone/deployments/custom-test-entity.jar");
        ((ZipExporter)entityArchive.as(ZipExporter.class)).exportTo(deployment1, true);
        deployments.add(deployment1);
        File deployment2 = new File(System.getProperty("server1.dist"), "/standalone/deployments/custom-compat-marshaller.jar");
        ((ZipExporter)marshallerArchive.as(ZipExporter.class)).exportTo(deployment2, true);
        deployments.add(deployment2);
    }

    @AfterClass
    public static void after() {
        if (remoteCacheManager != null) {
            remoteCacheManager.stop();
        }
        for (File f : deployments) {
            f.delete();
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="custom-compat-marshaller")})
    public void testCompatQuery() {
        remoteCacheManager = ITestUtils.createCacheManager(this.server1);
        RemoteCache remoteCache = remoteCacheManager.getCache();
        remoteCache.clear();
        for (int i = 0; i < 10; ++i) {
            TestEntity user = new TestEntity("name" + i);
            remoteCache.put((Object)i, (Object)user);
        }
        QueryFactory queryFactory = Search.getQueryFactory((RemoteCache)remoteCache);
        Query query = queryFactory.from(TestEntity.class).build();
        List list = query.list();
        Assert.assertEquals((long)10L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof TestEntity));
    }

    public static final class CustomCompatModeMarshaller
    extends AbstractJBossMarshaller {
        public CustomCompatModeMarshaller() {
            this.baseCfg.setClassResolver((ClassResolver)new DefaultContextClassResolver(((Object)((Object)this)).getClass().getClassLoader()));
        }
    }
}

