/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class RemoteQueryBaseIT {
    protected final String cacheContainerName;
    protected final String cacheName;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Integer, User> remoteCache;
    protected RemoteCacheManagerFactory rcmFactory;

    protected RemoteQueryBaseIT(String cacheContainerName, String cacheName) {
        this.cacheContainerName = cacheContainerName;
        this.cacheName = cacheName;
    }

    protected abstract RemoteInfinispanServer getServer();

    @Before
    public void setUp() throws Exception {
        this.rcmFactory = new RemoteCacheManagerFactory();
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host(this.getServer().getHotrodEndpoint().getInetAddress().getHostName()).port(this.getServer().getHotrodEndpoint().getPort()).marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = this.rcmFactory.createManager(clientBuilder);
        this.remoteCache = this.remoteCacheManager.getCache(this.cacheName);
        RemoteCache metadataCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)this.getClass().getClassLoader()));
        Assert.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        MarshallerRegistration.registerMarshallers((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager));
    }

    @After
    public void tearDown() {
        if (this.remoteCache != null) {
            try {
                this.remoteCache.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.remoteCache = null;
        }
        if (this.rcmFactory != null) {
            this.rcmFactory.stopManagers();
        }
        this.rcmFactory = null;
    }
}

