/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import java.io.IOException;
import java.util.stream.IntStream;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.infinispan.query.dsl.Query;
import org.infinispan.server.test.query.Transaction;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class IndexFlushingIT {
    private static final String SERVER = "query-index-flushing";
    @InfinispanResource(value="query-index-flushing")
    private RemoteInfinispanServer server;
    @ArquillianResource
    ContainerController controller;
    private RemoteCacheManager remoteCacheManager;

    @Before
    public void before() throws IOException {
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host(this.server.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server.getHotrodEndpoint().getPort()).marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        SerializationContext serializationContext = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager);
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
        String protoSchema = protoSchemaBuilder.fileName("transaction.proto").addClass(Transaction.class).build(serializationContext);
        RemoteCache metadataCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"transaction.proto", (Object)protoSchema);
    }

    @After
    public void after() {
        if (this.remoteCacheManager != null) {
            this.remoteCacheManager.stop();
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="query-index-flushing")})
    public void testIndexFlushing() {
        RemoteCache nrtCustomIndexCache = this.remoteCacheManager.getCache("nrt_custom_index_caches");
        RemoteCache nrtAutoConfigCache = this.remoteCacheManager.getCache("nrt_auto_config");
        this.writeToCache((RemoteCache<Integer, Transaction>)nrtCustomIndexCache);
        this.assertIndexSize((RemoteCache<Integer, Transaction>)nrtCustomIndexCache);
        this.writeToCache((RemoteCache<Integer, Transaction>)nrtAutoConfigCache);
        this.assertIndexSize((RemoteCache<Integer, Transaction>)nrtAutoConfigCache);
        this.restartServer();
        this.assertIndexSize((RemoteCache<Integer, Transaction>)nrtCustomIndexCache);
        this.assertIndexSize((RemoteCache<Integer, Transaction>)nrtAutoConfigCache);
    }

    private void restartServer() {
        this.controller.stop(SERVER);
        this.controller.start(SERVER);
    }

    private void writeToCache(RemoteCache<Integer, Transaction> remoteCache) {
        IntStream.range(0, 100).forEach(i -> {
            Transaction cfr_ignored_0 = (Transaction)remoteCache.put((Object)i, (Object)new Transaction(i, "script" + i));
        });
        Assert.assertEquals((String)"Cache should be populated", (long)100L, (long)remoteCache.size());
    }

    private void assertIndexSize(RemoteCache<Integer, Transaction> remoteCache) {
        Query query = Search.getQueryFactory(remoteCache).create("From Transaction");
        Assert.assertEquals((String)"Entries should be indexed", (long)100L, (long)query.getResultSize());
    }
}

