/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.partitionhandling;

import java.io.File;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.server.test.partitionhandling.CustomEntryMergePolicy;
import org.infinispan.server.test.util.ITestUtils;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CustomEntryMergePolicyIT {
    private static File deployment;
    @InfinispanResource(value="clustered-mergepolicies")
    RemoteInfinispanServer server;

    @BeforeClass
    public static void before() throws Exception {
        JavaArchive deployedMergePolicy = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        deployedMergePolicy.addPackage(CustomEntryMergePolicy.class.getPackage());
        deployedMergePolicy.addAsServiceProvider(EntryMergePolicy.class, new Class[]{CustomEntryMergePolicy.class});
        deployment = new File(System.getProperty("server1.dist"), "/standalone/deployments/custom-entry-merge-policy.jar");
        ((ZipExporter)deployedMergePolicy.as(ZipExporter.class)).exportTo(deployment, true);
    }

    @AfterClass
    public static void after() {
        if (deployment != null) {
            deployment.delete();
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="clustered-mergepolicies")})
    public void testIfDeployedCacheContainsProperValues() throws Exception {
        RemoteCacheManager rcm = ITestUtils.createCacheManager(this.server);
        Assert.assertNotNull((Object)rcm.getCache());
    }
}

