/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.jmx.suppress.statetransfer;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.infinispan.server.test.util.ITestUtils;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class StateTransferSuppressIT {
    private static final Logger log = Logger.getLogger(StateTransferSuppressIT.class);
    protected static final String CONTAINER1 = "suppress-state-transfer-1";
    protected static final String CONTAINER2 = "suppress-state-transfer-2";
    protected static final String CONTAINER3 = "suppress-state-transfer-3";
    private static final int NUMBER_ENTRIES = 1000;
    private static final String CACHE_MANAGER_NAME = "clustered";
    private static final String MEMCACHED_CACHE_NAME = "memcachedCache";
    private static final String HOTROD_CACHE_NAME = "default";
    final String HOTROD_DIST_CACHE_PREFIX = "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"" + this.getCacheManagerName() + "\",component=";
    final String MEMCACHED_DIST_CACHE_PREFIX = "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"" + this.getCacheManagerName() + "\",component=";
    final String HOTROD_RPC_MANAGER_MBEAN = this.HOTROD_DIST_CACHE_PREFIX + "RpcManager";
    final String MEMCACHED_RPC_MANAGER_MBEAN = this.MEMCACHED_DIST_CACHE_PREFIX + "RpcManager";
    final String REBALANCE_ENABLED_ATTR_NAME = "RebalancingEnabled";
    final String COMMITTED_VIEW_AS_STRING_ATTR_NAME = "CommittedViewAsString";
    final String PENDING_VIEW_AS_STRING_ATTR_NAME = "PendingViewAsString";
    private final String OWNERS_2_MEMBERS_NODE1_NODE2 = "[node0, node1]";
    private final String OWNERS_2_MEMBERS_NODE2_NODE3 = "[node1, node2]";
    private final String OWNERS_2_MEMBERS_NODE1_NODE2_NODE3 = "[node0, node1, node2]";
    private final String LOCAL_TOPOLOGY_MANAGER = "jboss.datagrid-infinispan:type=CacheManager,name=\"" + this.getCacheManagerName() + "\",component=LocalTopologyManager";
    @InfinispanResource(value="suppress-state-transfer-1")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="suppress-state-transfer-2")
    RemoteInfinispanServer server2;
    @InfinispanResource(value="suppress-state-transfer-3")
    RemoteInfinispanServer server3;
    @ArquillianResource
    ContainerController controller;
    protected final List<MBeanServerConnectionProvider> providers = new ArrayList<MBeanServerConnectionProvider>();
    private RemoteCacheManager rcm1;
    private RemoteCacheManager rcm2;
    private RemoteCache cache1;
    private RemoteCache cache2;
    private MemcachedClient mc;

    @Before
    public void setUp() throws Exception {
        this.providers.clear();
        this.providers.add(new MBeanServerConnectionProvider(this.server1.getHotrodEndpoint().getInetAddress().getHostName(), 9990));
        this.providers.add(new MBeanServerConnectionProvider(this.server1.getHotrodEndpoint().getInetAddress().getHostName(), 10090));
        this.providers.add(new MBeanServerConnectionProvider(this.server1.getHotrodEndpoint().getInetAddress().getHostName(), 10190));
        this.rcm1 = ITestUtils.createCacheManager(this.server1);
        this.rcm2 = ITestUtils.createCacheManager(this.server2);
        this.cache1 = this.rcm1.getCache(HOTROD_CACHE_NAME);
        this.cache2 = this.rcm2.getCache(HOTROD_CACHE_NAME);
        try {
            this.mc = new MemcachedClient("UTF-8", this.server1.getMemcachedEndpoint().getInetAddress().getHostName(), this.server1.getMemcachedEndpoint().getPort(), this.server1.getMemcachedEndpoint().getPort());
        }
        catch (Exception ex) {
            log.warn((Object)"prepare() method throws exception", (Throwable)ex);
        }
    }

    @After
    public void tearDown() throws Exception {
        if (null != this.rcm1) {
            this.rcm1.stop();
        }
        if (null != this.rcm2) {
            this.rcm2.stop();
        }
    }

    protected MBeanServerConnectionProvider provider(int index) {
        return this.providers.get(index);
    }

    private String getCacheManagerName() {
        return CACHE_MANAGER_NAME;
    }

    private long numEntries(RemoteInfinispanServer server, String cacheName) {
        return server.getCacheManager(this.getCacheManagerName()).getCache(cacheName).getNumberOfEntries();
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="suppress-state-transfer-1"), @RunningServer(name="suppress-state-transfer-2")})
    public void testRebalanceWithFirstNodeStop() throws Exception {
        try {
            this.verifyRebalanceWith3rdNode();
            ITestUtils.setAttribute(this.provider(0), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", false);
            this.controller.stop(CONTAINER1);
            this.checkRpcManagerStatistics(new String[]{"null", "[node1, node2]"}, "[node1, node2]", this.provider(1), this.provider(2));
            this.checkRebalanceStatus(false, this.provider(1), this.provider(2));
            Assert.assertTrue((this.numEntries(this.server2, HOTROD_CACHE_NAME) < 1000L ? 1 : 0) != 0);
            Assert.assertTrue((this.numEntries(this.server3, HOTROD_CACHE_NAME) < 1000L ? 1 : 0) != 0);
            Assert.assertTrue((this.numEntries(this.server2, MEMCACHED_CACHE_NAME) < 1000L ? 1 : 0) != 0);
            Assert.assertTrue((this.numEntries(this.server3, MEMCACHED_CACHE_NAME) < 1000L ? 1 : 0) != 0);
            ITestUtils.setAttribute(this.provider(1), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", true);
            this.checkRebalanceStatus(true, this.provider(1), this.provider(2));
            this.checkRpcManagerStatistics(new String[]{"null", "[node1, node2]"}, "[node1, node2]", this.provider(1), this.provider(2));
            Assert.assertTrue((this.numEntries(this.server2, HOTROD_CACHE_NAME) == 1000L ? 1 : 0) != 0);
            Assert.assertTrue((this.numEntries(this.server3, HOTROD_CACHE_NAME) == 1000L ? 1 : 0) != 0);
            Assert.assertTrue((this.numEntries(this.server2, MEMCACHED_CACHE_NAME) == 1000L ? 1 : 0) != 0);
            Assert.assertTrue((this.numEntries(this.server3, MEMCACHED_CACHE_NAME) == 1000L ? 1 : 0) != 0);
        }
        finally {
            this.controller.stop(CONTAINER3);
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="suppress-state-transfer-1"), @RunningServer(name="suppress-state-transfer-2")})
    public void testRebalanceWithJoinedNodeStop() throws Exception {
        this.verifyRebalanceWith3rdNode();
        ITestUtils.setAttribute(this.provider(0), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", false);
        this.controller.stop(CONTAINER3);
        this.checkRpcManagerStatistics(new String[]{"null", "[node0, node1]"}, "[node0, node1]", this.provider(0), this.provider(1));
        this.checkRebalanceStatus(false, this.provider(0), this.provider(1));
        Assert.assertTrue((this.numEntries(this.server1, HOTROD_CACHE_NAME) < 1000L ? 1 : 0) != 0);
        Assert.assertTrue((this.numEntries(this.server2, HOTROD_CACHE_NAME) < 1000L ? 1 : 0) != 0);
        Assert.assertTrue((this.numEntries(this.server1, MEMCACHED_CACHE_NAME) < 1000L ? 1 : 0) != 0);
        Assert.assertTrue((this.numEntries(this.server2, MEMCACHED_CACHE_NAME) < 1000L ? 1 : 0) != 0);
        ITestUtils.setAttribute(this.provider(1), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", true);
        this.checkRebalanceStatus(true, this.provider(0), this.provider(1));
        this.checkRpcManagerStatistics(new String[]{"null", "[node0, node1]"}, "[node0, node1]", this.provider(0), this.provider(1));
        Assert.assertTrue((this.numEntries(this.server1, HOTROD_CACHE_NAME) == 1000L ? 1 : 0) != 0);
        Assert.assertTrue((this.numEntries(this.server2, HOTROD_CACHE_NAME) == 1000L ? 1 : 0) != 0);
        Assert.assertTrue((this.numEntries(this.server1, MEMCACHED_CACHE_NAME) == 1000L ? 1 : 0) != 0);
        Assert.assertTrue((this.numEntries(this.server2, MEMCACHED_CACHE_NAME) == 1000L ? 1 : 0) != 0);
    }

    private void verifyRebalanceWith3rdNode() throws Exception {
        ITestUtils.setAttribute(this.provider(0), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", false);
        this.putDataIntoCache(1000);
        this.checkRebalanceStatus(false, this.provider(0), this.provider(1));
        this.checkRpcManagerStatistics(new String[]{"null"}, "[node0, node1]", this.provider(0), this.provider(1));
        this.controller.start(CONTAINER3);
        this.checkRebalanceStatus(false, this.provider(2));
        this.checkRpcManagerStatistics(new String[]{"null"}, "[node0, node1]", this.provider(0), this.provider(1), this.provider(2));
        Assert.assertTrue((String)"The hotrod cache on server(2) should be empty.", (this.numEntries(this.server3, HOTROD_CACHE_NAME) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"The memcached cache on server(2) should be empty.", (this.numEntries(this.server3, MEMCACHED_CACHE_NAME) == 0L ? 1 : 0) != 0);
        ITestUtils.setAttribute(this.provider(0), this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled", true);
        this.checkRebalanceStatus(true, this.provider(0), this.provider(1), this.provider(2));
        this.checkRpcManagerStatistics(new String[]{"null", "[node0, node1, node2]"}, null, this.provider(0), this.provider(1), this.provider(2));
        this.checkRpcManagerStatistics(new String[]{"null"}, "[node0, node1, node2]", this.provider(0), this.provider(1), this.provider(2));
        Assert.assertTrue((this.numEntries(this.server1, HOTROD_CACHE_NAME) < 1000L ? 1 : 0) != 0);
        Assert.assertTrue((this.numEntries(this.server2, HOTROD_CACHE_NAME) < 1000L ? 1 : 0) != 0);
        Assert.assertTrue((this.numEntries(this.server3, HOTROD_CACHE_NAME) < 1000L ? 1 : 0) != 0);
        Assert.assertTrue((this.numEntries(this.server1, MEMCACHED_CACHE_NAME) < 1000L ? 1 : 0) != 0);
        Assert.assertTrue((this.numEntries(this.server2, MEMCACHED_CACHE_NAME) < 1000L ? 1 : 0) != 0);
        Assert.assertTrue((this.numEntries(this.server3, MEMCACHED_CACHE_NAME) < 1000L ? 1 : 0) != 0);
    }

    private void checkRebalanceStatus(final boolean expectedStatus, MBeanServerConnectionProvider ... providers) throws Exception {
        for (final MBeanServerConnectionProvider provider : providers) {
            ITestUtils.eventually(new ITestUtils.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return expectedStatus == Boolean.parseBoolean(ITestUtils.getAttribute(provider, StateTransferSuppressIT.this.LOCAL_TOPOLOGY_MANAGER, "RebalancingEnabled"));
                }
            }, 10000L);
        }
    }

    private void checkRpcManagerStatistics(String[] expectedPendingViews, final String expectedCommitedView, MBeanServerConnectionProvider ... providers) throws Exception {
        for (final MBeanServerConnectionProvider provider : providers) {
            if (expectedCommitedView != null) {
                ITestUtils.eventually(new ITestUtils.Condition(){

                    @Override
                    public boolean isSatisfied() throws Exception {
                        String hotrodCommittedViewAsString = String.valueOf(ITestUtils.getAttribute(provider, StateTransferSuppressIT.this.HOTROD_RPC_MANAGER_MBEAN, "CommittedViewAsString"));
                        String memcachedCommittedViewAsString = String.valueOf(ITestUtils.getAttribute(provider, StateTransferSuppressIT.this.MEMCACHED_RPC_MANAGER_MBEAN, "CommittedViewAsString"));
                        return expectedCommitedView.equals(hotrodCommittedViewAsString) && expectedCommitedView.equals(memcachedCommittedViewAsString);
                    }
                }, 10000L);
            }
            String hotrodPendingViewAsString = String.valueOf(ITestUtils.getAttribute(provider, this.HOTROD_RPC_MANAGER_MBEAN, "PendingViewAsString"));
            String memcachedPendingViewAsString = String.valueOf(ITestUtils.getAttribute(provider, this.MEMCACHED_RPC_MANAGER_MBEAN, "PendingViewAsString"));
            boolean hotrodPassed = false;
            boolean memcachedPassed = false;
            for (String expectedPendingView : expectedPendingViews) {
                if (expectedPendingView.equals(hotrodPendingViewAsString)) {
                    hotrodPassed = true;
                }
                if (!expectedPendingView.equals(memcachedPendingViewAsString)) continue;
                memcachedPassed = true;
            }
            Assert.assertTrue((String)("The pending view doesn't match to any of expected ones, but is " + hotrodPendingViewAsString + "."), (boolean)hotrodPassed);
            Assert.assertTrue((String)("The pending view doesn't match to any of expected ones, but is " + memcachedPendingViewAsString + "."), (boolean)memcachedPassed);
        }
    }

    private void putDataIntoCache(int count) {
        int i;
        for (i = 0; i < count; ++i) {
            this.cache1.put((Object)("key" + i), (Object)("value" + i));
        }
        Assert.assertTrue((String)"The size of both caches should be equal.", (this.cache1.size() == this.cache2.size() ? 1 : 0) != 0);
        Assert.assertEquals((long)count, (long)this.cache1.size());
        Assert.assertEquals((long)count, (long)this.cache2.size());
        try {
            for (i = 0; i < count; ++i) {
                this.mc.set("key" + i, "value" + i);
            }
            long num1 = this.numEntries(this.server1, MEMCACHED_CACHE_NAME);
            long num2 = this.numEntries(this.server2, MEMCACHED_CACHE_NAME);
            Assert.assertEquals((String)"The size of both caches should be equal.", (long)num1, (long)num2);
            Assert.assertEquals((long)count, (long)num1);
            Assert.assertEquals((long)count, (long)num2);
        }
        catch (Exception ex) {
            log.error((Object)"putDataIntoCache() throws exception", (Throwable)ex);
        }
    }
}

