/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.jmx.management;

import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={@RunningServer(name="jmx-jolokia")})
public class JmxManagementJolokiaIT {
    private static final String JOLOKIA_URL = "http://localhost:8779/jolokia";
    private static HttpClient httpClient;

    @BeforeClass
    public static void setUp() throws Exception {
        httpClient = HttpClientBuilder.create().build();
    }

    @Test
    public void testJolokiaVersion() throws IOException {
        HttpGet get = this.createHttpGet("/version");
        HttpResponse response = httpClient.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
    }

    @Test
    public void testJolokiaMemoryAccess() throws IOException {
        HttpGet get = this.createHttpGet("/read/java.lang:type=Memory/HeapMemoryUsage");
        HttpResponse response = httpClient.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
    }

    private HttpGet createHttpGet(String relativeUrl) {
        return new HttpGet(JOLOKIA_URL + relativeUrl);
    }
}

