/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.jmx.management;

import java.util.List;
import javax.management.ObjectName;
import org.apache.http.HttpResponse;
import org.infinispan.Version;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.server.test.category.Unstable;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.infinispan.server.test.client.rest.RESTHelper;
import org.infinispan.server.test.util.ITestUtils;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={@RunningServer(name="jmx-management-1"), @RunningServer(name="jmx-management-2")})
public class JmxManagementIT {
    final String JMX_DOMAIN = "jboss.datagrid-infinispan";
    final String distCachePrefix = "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=";
    final String memcachedCachePrefix = "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=";
    final String distCacheMBean = "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Cache";
    final String distributionManagerMBean = "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=DistributionManager";
    final String distributionStateTransferManagerMBean = "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=StateTransferManager";
    final String lockManagerMBean = "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=LockManager";
    final String rpcManagerMBean = "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager";
    final String distCacheStatisticsMBean = "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Statistics";
    final String memcachedCacheStatisticsMBean = "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics";
    final String newExtraCacheMBean = "jboss.datagrid-infinispan:type=Cache,name=\"extracache(local)\",manager=\"clustered\",component=Cache";
    final String managerPrefix = "jboss.datagrid-infinispan:type=CacheManager,name=\"clustered\",component=";
    final String cacheManagerMBean = "jboss.datagrid-infinispan:type=CacheManager,name=\"clustered\",component=CacheManager";
    final String hotRodTransportMBean = "jboss.datagrid-infinispan:type=Server,name=HotRod,component=Transport";
    final String hotRodExecutorMBean = "jboss.datagrid-infinispan:type=Server,name=HotRod,component=WorkerExecutor";
    final String memCachedTransportMBean = "jboss.datagrid-infinispan:type=Server,name=Memcached,component=Transport";
    final String memCachedExecutorMBean = "jboss.datagrid-infinispan:type=Server,name=Memcached,component=WorkerExecutor";
    final String restTransportMBean = "jboss.datagrid-infinispan:type=Server,name=REST,component=Transport";
    final String restExecutorMBean = "jboss.datagrid-infinispan:type=Server,name=REST,component=WorkerExecutor";
    final String protocolMBeanPrefix = "jgroups:type=protocol,cluster=\"default\",protocol=";
    @InfinispanResource(value="jmx-management-1")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="jmx-management-2")
    RemoteInfinispanServer server2;
    MBeanServerConnectionProvider provider;
    MBeanServerConnectionProvider provider2;
    RemoteCacheManager manager;
    RemoteCache distCache;
    MemcachedClient mc;
    RESTHelper rest;

    @Before
    public void setUp() throws Exception {
        if (this.provider == null) {
            this.provider = new MBeanServerConnectionProvider(this.server1.getHotrodEndpoint().getInetAddress().getHostName(), 9990);
            this.provider2 = new MBeanServerConnectionProvider(this.server2.getHotrodEndpoint().getInetAddress().getHostName(), 10090);
            Configuration conf = new ConfigurationBuilder().addServer().host(this.server1.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server1.getHotrodEndpoint().getPort()).build();
            this.manager = new RemoteCacheManager(conf);
            this.distCache = this.manager.getCache();
            this.mc = new MemcachedClient("UTF-8", this.server1.getMemcachedEndpoint().getInetAddress().getHostName(), this.server1.getMemcachedEndpoint().getPort(), 10000);
            this.rest = new RESTHelper();
            this.rest.addServer(this.server1.getRESTEndpoint().getInetAddress().getHostName(), this.server1.getRESTEndpoint().getContextPath());
        }
        this.resetCacheStatistics();
        this.distCache.clear();
    }

    private void resetCacheStatistics() throws Exception {
        ITestUtils.invokeOperation(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "resetStatistics", null, null);
    }

    private static int getNumberOfGlobalConnections(MBeanServerConnectionProvider provider, String mbean) throws Exception {
        return Integer.parseInt(ITestUtils.getAttribute(provider, mbean, "numberOfGlobalConnections"));
    }

    private static int getNumberOfLocalConnections(MBeanServerConnectionProvider provider, String mbean) throws Exception {
        return Integer.parseInt(ITestUtils.getAttribute(provider, mbean, "numberOfLocalConnections"));
    }

    @Test
    @Category(value={Unstable.class})
    public void testHotRodConnectionCount() throws Exception {
        int initialLocal = JmxManagementIT.getNumberOfLocalConnections(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=Transport");
        int initialGlobal = JmxManagementIT.getNumberOfGlobalConnections(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=Transport");
        Assert.assertEquals((String)"Number of global connections obtained from node1 and node2 is not the same", (long)initialGlobal, (long)JmxManagementIT.getNumberOfGlobalConnections(this.provider2, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=Transport"));
        Configuration conf = new ConfigurationBuilder().addServer().host(this.server1.getHotrodEndpoint().getInetAddress().getHostAddress()).port(this.server1.getHotrodEndpoint().getPort()).build();
        RemoteCacheManager manager2 = new RemoteCacheManager(conf);
        manager2.getCache().put((Object)"key", (Object)"value");
        Assert.assertEquals((long)(initialLocal + 1), (long)JmxManagementIT.getNumberOfLocalConnections(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=Transport"));
        Assert.assertEquals((long)(initialGlobal + 2), (long)JmxManagementIT.getNumberOfGlobalConnections(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=Transport"));
        Assert.assertEquals((long)(initialGlobal + 2), (long)JmxManagementIT.getNumberOfGlobalConnections(this.provider2, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=Transport"));
    }

    @Test
    @Category(value={Unstable.class})
    public void testMemCachedConnectionCount() throws Exception {
        int initialLocal = JmxManagementIT.getNumberOfLocalConnections(this.provider, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=Transport");
        int initialGlobal = JmxManagementIT.getNumberOfGlobalConnections(this.provider, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=Transport");
        Assert.assertEquals((String)"Number of global connections obtained from node1 and node2 is not the same", (long)initialGlobal, (long)JmxManagementIT.getNumberOfGlobalConnections(this.provider2, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=Transport"));
        MemcachedClient mc2 = new MemcachedClient("UTF-8", this.server1.getMemcachedEndpoint().getInetAddress().getHostName(), this.server1.getMemcachedEndpoint().getPort(), 10000);
        mc2.set("key", "value");
        Assert.assertEquals((long)(initialLocal + 1), (long)JmxManagementIT.getNumberOfLocalConnections(this.provider, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=Transport"));
        Assert.assertEquals((long)(initialGlobal + 1), (long)JmxManagementIT.getNumberOfGlobalConnections(this.provider, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=Transport"));
        Assert.assertEquals((long)(initialGlobal + 1), (long)JmxManagementIT.getNumberOfGlobalConnections(this.provider2, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=Transport"));
    }

    @Test
    public void testHotRodServerAttributes() throws Exception {
        this.distCache.put((Object)"key1", (Object)new byte[]{1, 2, 3, 4, 5});
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=Transport", "TotalBytesRead")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=Transport", "TotalBytesWritten")));
        Assert.assertEquals((long)11222L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=Transport", "Port")));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=Transport", "tcpNoDelay")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=Transport", "ReceiveBufferSize")));
        Assert.assertEquals((long)-1L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=Transport", "IdleTimeout")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=Transport", "SendBufferSize")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=Transport", "NumberIOThreads")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=Transport", "PendingTasks")));
        Assert.assertNotEquals((long)0L, (long)ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=Transport", "HostName").length());
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=WorkerExecutor", "PoolSize")));
        int maxPoolSize = Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=WorkerExecutor", "MaximumPoolSize"));
        Assert.assertNotEquals((long)0L, (long)maxPoolSize);
        ITestUtils.setAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=WorkerExecutor", "MaximumPoolSize", maxPoolSize + 1);
        Assert.assertEquals((long)(maxPoolSize + 1), (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=HotRod,component=WorkerExecutor", "MaximumPoolSize")));
    }

    @Test
    public void testMemcachedServerAttributes() throws Exception {
        this.mc.set("key1", "value1");
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=Transport", "TotalBytesRead")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=Transport", "TotalBytesWritten")));
        Assert.assertEquals((long)11211L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=Transport", "Port")));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=Transport", "tcpNoDelay")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=Transport", "ReceiveBufferSize")));
        Assert.assertEquals((long)-1L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=Transport", "IdleTimeout")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=Transport", "SendBufferSize")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=Transport", "NumberIOThreads")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=Transport", "PendingTasks")));
        Assert.assertNotEquals((long)0L, (long)ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=Transport", "HostName").length());
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=WorkerExecutor", "PoolSize")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=Memcached,component=WorkerExecutor", "MaximumPoolSize")));
    }

    @Test
    public void testRestServerAttributes() throws Exception {
        HttpResponse insert = this.rest.put(this.rest.fullPathKey("restKey"), "restValue", "text/plain");
        Assert.assertEquals((long)0L, (long)insert.getEntity().getContentLength());
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=REST,component=Transport", "TotalBytesRead")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=REST,component=Transport", "TotalBytesWritten")));
        Assert.assertEquals((long)8080L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=REST,component=Transport", "Port")));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=REST,component=Transport", "tcpNoDelay")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=REST,component=Transport", "ReceiveBufferSize")));
        Assert.assertEquals((long)-1L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=REST,component=Transport", "IdleTimeout")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=REST,component=Transport", "SendBufferSize")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=REST,component=Transport", "NumberIOThreads")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=REST,component=Transport", "PendingTasks")));
        Assert.assertNotEquals((long)0L, (long)ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=REST,component=Transport", "HostName").length());
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=REST,component=WorkerExecutor", "PoolSize")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Server,name=REST,component=WorkerExecutor", "MaximumPoolSize")));
    }

    @Test
    public void testCacheManagerAttributes() throws Exception {
        Assert.assertEquals((long)2L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "CreatedCacheCount")));
        Assert.assertEquals((long)4L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "DefinedCacheCount")));
        Assert.assertEquals((Object)"clustered", (Object)ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "Name"));
        Assert.assertEquals((long)2L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "ClusterSize")));
        Assert.assertEquals((Object)"RUNNING", (Object)ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "CacheManagerStatus"));
        Assert.assertNotEquals((long)0L, (long)ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "ClusterMembers").length());
        Assert.assertNotEquals((long)0L, (long)ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "NodeAddress").length());
        Assert.assertEquals((long)2L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "RunningCacheCount")));
        Assert.assertNotEquals((long)0L, (long)ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "PhysicalAddresses").length());
        Assert.assertEquals((Object)Version.getVersion(), (Object)ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "Version"));
        String names = ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=CacheManager,name=\"clustered\",component=CacheManager", "DefinedCacheNames");
        Assert.assertTrue((names.contains("default") && names.contains("memcachedCache") ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultCacheAttributes() throws Exception {
        Assert.assertTrue((boolean)ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Cache", "CacheName").contains("default"));
        Assert.assertEquals((Object)"RUNNING", (Object)ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Cache", "CacheStatus"));
    }

    @Test
    public void testDefaultCacheOperations() throws Exception {
        Assert.assertEquals((Object)"RUNNING", (Object)ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Cache", "CacheStatus"));
        ITestUtils.invokeOperation(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Cache", "stop", null, null);
        Assert.assertEquals((Object)"TERMINATED", (Object)ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Cache", "CacheStatus"));
        ITestUtils.invokeOperation(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Cache", "start", null, null);
        Assert.assertEquals((Object)"RUNNING", (Object)ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=Cache", "CacheStatus"));
    }

    @Test
    public void testDistributionStateTransferManagerAttributes() throws Exception {
        Assert.assertEquals((Object)Boolean.FALSE, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=StateTransferManager", "StateTransferInProgress")));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=StateTransferManager", "JoinComplete")));
    }

    @Test
    public void testDistributionManagerOperations() throws Exception {
        this.distCache.put((Object)"key2", (Object)"value1");
        Assert.assertEquals((Object)Boolean.FALSE, (Object)Boolean.parseBoolean(ITestUtils.invokeOperation(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=DistributionManager", "isAffectedByRehash", new Object[]{"key2"}, new String[]{"java.lang.Object"}).toString()));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Boolean.parseBoolean(ITestUtils.invokeOperation(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=DistributionManager", "isLocatedLocally", new Object[]{"key2"}, new String[]{"java.lang.String"}).toString()));
        Object keyLocation = ITestUtils.invokeOperation(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=DistributionManager", "locateKey", new Object[]{"key1"}, new String[]{"java.lang.String"});
        Assert.assertTrue((boolean)(keyLocation instanceof List));
    }

    @Test
    public void testLockManagerAttributes() throws Exception {
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=LockManager", "NumberOfLocksHeld")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=LockManager", "NumberOfLocksAvailable")));
        Assert.assertEquals((long)1000L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=LockManager", "ConcurrencyLevel")));
    }

    @Test
    public void testCacheStatisticsAttributes() throws Exception {
        this.mc.set("key1", "value1");
        this.mc.set("key2", "value2");
        this.mc.get("key1");
        Assert.assertEquals((long)2L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "NumberOfEntries")));
        Assert.assertEquals((long)1L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "NumberOfEntriesInMemory")));
        this.mc.delete("key1");
        Assert.assertEquals((long)2L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "Evictions")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "RemoveMisses")));
        Assert.assertNotEquals((Object)0.0, (Object)Double.parseDouble(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "ReadWriteRatio")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "Hits")));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "StatisticsEnabled")));
        ITestUtils.sleepForSecs(2.0);
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "TimeSinceReset")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "ElapsedTime")));
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "Misses")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "RemoveHits")));
        Assert.assertNotEquals(null, (Object)ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "AverageWriteTime"));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "Stores")));
        Assert.assertTrue((1.0 == Double.parseDouble(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "HitRatio")) ? 1 : 0) != 0);
        Assert.assertNotEquals(null, (Object)ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "AverageReadTime"));
    }

    @Test
    public void testCacheStatisticsOperations() throws Exception {
        this.resetCacheStatistics();
        this.mc.set("key1", "value1");
        Assert.assertEquals((long)1L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "Stores")));
        this.resetCacheStatistics();
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"memcachedCache(dist_sync)\",manager=\"clustered\",component=Statistics", "Stores")));
    }

    @Test
    public void testRpcManagerAttributes() throws Exception {
        this.distCache.put((Object)"key1", (Object)"value1");
        this.distCache.put((Object)"key2", (Object)"value2");
        this.distCache.put((Object)"key3", (Object)"value3");
        Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "AverageReplicationTime"));
        Assert.assertTrue((1.0 == Double.parseDouble(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "SuccessRatioFloatingPoint")) ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "ReplicationFailures")));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Boolean.parseBoolean(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "StatisticsEnabled")));
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "ReplicationCount")));
        Assert.assertEquals((Object)"100%", (Object)ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "SuccessRatio"));
    }

    @Test
    public void testRpcManagerOperations() throws Exception {
        Assert.assertNotEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "ReplicationCount")));
        ITestUtils.invokeOperation(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "resetStatistics", null, null);
        Assert.assertEquals((long)0L, (long)Integer.parseInt(ITestUtils.getAttribute(this.provider, "jboss.datagrid-infinispan:type=Cache,name=\"default(dist_sync)\",manager=\"clustered\",component=RpcManager", "ReplicationCount")));
    }

    @Test
    public void testJGroupsChannelMBeanAvailable() throws Exception {
        Assert.assertTrue((boolean)this.provider.getConnection().isRegistered(new ObjectName("jgroups:type=channel,cluster=\"cluster\"")));
    }
}

