/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.dataconversion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.server.test.dataconversion.Currency;
import org.infinispan.server.test.util.ITestUtils;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ObjectStorageIT {
    static final String DEPLOY_PATH = "/standalone/deployments/entities.jar";
    static final String SERVER = "standalone-pojo-storage";
    static final ObjectMapper mapper = new ObjectMapper();
    @InfinispanResource(value="standalone-pojo-storage")
    RemoteInfinispanServer server;
    private static CloseableHttpClient httpClient;

    @BeforeClass
    public static void before() {
        httpClient = HttpClients.createDefault();
        String serverDir = System.getProperty("server1.dist");
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Currency.class)).add((Asset)new StringAsset("Dependencies: org.infinispan.commons"), "META-INF/MANIFEST.MF");
        File f = new File(serverDir, DEPLOY_PATH);
        ((ZipExporter)jar.as(ZipExporter.class)).exportTo(f, true);
    }

    @AfterClass
    public static void cleanUp() {
        File f;
        try {
            httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String serverDir = System.getProperty("server1.dist");
        File jar = new File(serverDir, DEPLOY_PATH);
        if (jar.exists()) {
            jar.delete();
        }
        if ((f = new File(serverDir, "/standalone/deployments/entities.jar.deployed")).exists()) {
            f.delete();
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-pojo-storage")})
    public void shouldDeserializeStringContent() throws IOException {
        RemoteCacheManager rcm = ITestUtils.createCacheManager(this.server);
        RemoteCache remoteCache = rcm.getCache();
        remoteCache.put((Object)1, (Object)new Currency("United States", "USD"));
        remoteCache.put((Object)2, (Object)new Currency("Algeria", "DZD"));
        JsonNode jsonNode = this.readJSON(1);
        Assert.assertEquals((Object)"United States", (Object)jsonNode.get("country").asText());
        Assert.assertEquals((Object)"USD", (Object)jsonNode.get("symbol").asText());
        JsonNode anotherNode = this.readJSON(2);
        Assert.assertEquals((Object)Currency.class.getName(), (Object)anotherNode.get("_type").asText());
        String newCurrency = "{\"_type\":\"org.infinispan.server.test.dataconversion.Currency\",\"country\":\"Bulgaria\",\"symbol\":\"BGN\"}";
        this.writeViaRest(3, newCurrency, MediaType.APPLICATION_JSON);
        Currency bgn = (Currency)remoteCache.get((Object)3);
        Assert.assertEquals((Object)"Bulgaria", (Object)bgn.getCountry());
        Assert.assertEquals((Object)"BGN", (Object)bgn.getSymbol());
        String newCurrencyXML = "<org.infinispan.server.test.dataconversion.Currency><country>Mexico</country><symbol>MXN</symbol></org.infinispan.server.test.dataconversion.Currency>";
        this.writeViaRest(4, newCurrencyXML, MediaType.APPLICATION_XML);
        Currency mxn = (Currency)remoteCache.get((Object)4);
        Assert.assertEquals((Object)"Mexico", (Object)mxn.getCountry());
        Assert.assertEquals((Object)"MXN", (Object)mxn.getSymbol());
    }

    private void writeViaRest(Integer key, String newCurrency, MediaType valueFormat) throws IOException {
        HttpPost httpPost = new HttpPost(this.getURL(key));
        httpPost.addHeader("Content-Type", valueFormat.toString());
        httpPost.addHeader("Key-Content-Type", "application/x-java-object; type=java.lang.Integer");
        httpPost.setEntity((HttpEntity)new StringEntity(newCurrency));
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
    }

    private String getURL(Integer key) {
        return "http://localhost:8080/rest/default/" + key;
    }

    private JsonNode readJSON(Integer key) throws IOException {
        String json = this.readViaRest(key, MediaType.APPLICATION_JSON);
        return mapper.readTree(json);
    }

    private String readViaRest(Integer key, MediaType valueFormat) throws IOException {
        HttpGet get = new HttpGet(this.getURL(key));
        get.addHeader("Accept", valueFormat.toString());
        get.addHeader("Key-Content-Type", "application/x-java-object; type=java.lang.Integer");
        CloseableHttpResponse getResponse = httpClient.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)getResponse.getStatusLine().getStatusCode());
        return EntityUtils.toString((HttpEntity)getResponse.getEntity());
    }
}

