/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.jdbc.multinode;

import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.cs.jdbc.AbstractJdbcStoreMultinodeIT;
import org.infinispan.server.test.util.ITestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CacheStore.class})
@WithRunningServer(value={@RunningServer(name="jdbc-cachestore-1", config="testsuite/jdbc-string-invalidation.xml"), @RunningServer(name="jdbc-cachestore-2", config="testsuite/jdbc-string-invalidation.xml")})
public class StringBasedStoreInvalidationCacheSyncIT
extends AbstractJdbcStoreMultinodeIT {
    private final String TABLE_NAME_PREFIX = "STRING_INVALIDATION";
    private final String CACHE_NAME = "memcachedCache";
    private final String MANAGER_NAME = "clustered";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.mc1 = ITestUtils.createMemcachedClient(this.server1);
        this.mc2 = ITestUtils.createMemcachedClient(this.server2);
        this.assertCleanCache();
    }

    @Test
    public void testResurrectEntry() throws Exception {
        this.mc1.set("key", "value");
        Assert.assertEquals((Object)"value", (Object)this.mc1.get("key"));
        Assert.assertNotNull((Object)StringBasedStoreInvalidationCacheSyncIT.dbServer1.stringTable.getValueByByteArrayKey("key"));
        Assert.assertEquals((long)0L, (long)this.server2.getCacheManager("clustered").getCache("memcachedCache").getNumberOfEntriesInMemory());
        Assert.assertEquals((Object)"value", (Object)this.mc2.get("key"));
        this.mc1.set("key", "newValue1");
        Assert.assertEquals((Object)"newValue1", (Object)this.mc1.get("key"));
        Assert.assertEquals((long)0L, (long)this.server2.getCacheManager("clustered").getCache("memcachedCache").getNumberOfEntriesInMemory());
        Assert.assertEquals((Object)"newValue1", (Object)this.mc2.get("key"));
        this.mc2.set("key", "newValue2");
        Assert.assertEquals((Object)"newValue2", (Object)this.mc2.get("key"));
        Assert.assertEquals((long)0L, (long)this.server1.getCacheManager("clustered").getCache("memcachedCache").getNumberOfEntriesInMemory());
        Assert.assertEquals((Object)"newValue2", (Object)this.mc1.get("key"));
    }

    @Test
    public void testRemoveEntry() throws Exception {
        this.mc1.set("key", "value");
        Assert.assertEquals((Object)"value", (Object)this.mc1.get("key"));
        Assert.assertEquals((Object)"value", (Object)this.mc2.get("key"));
        this.mc2.delete("key");
        Assert.assertEquals(null, (Object)this.mc1.get("key"));
        Assert.assertEquals(null, (Object)this.mc2.get("key"));
        Assert.assertEquals(null, (Object)StringBasedStoreInvalidationCacheSyncIT.dbServer1.stringTable.getValueByKey("key"));
    }

    @Test
    public void testRemoveNonExistentEntry() throws Exception {
        this.mc1.set("key", "value");
        Assert.assertEquals((Object)"value", (Object)this.mc1.get("key"));
        Assert.assertEquals((long)1L, (long)this.server1.getCacheManager("clustered").getCache("memcachedCache").getNumberOfEntriesInMemory());
        Assert.assertEquals((long)0L, (long)this.server2.getCacheManager("clustered").getCache("memcachedCache").getNumberOfEntriesInMemory());
        this.mc2.delete("key");
        Assert.assertEquals(null, (Object)this.mc1.get("key"));
        Assert.assertEquals(null, (Object)this.mc2.get("key"));
        Assert.assertEquals(null, (Object)StringBasedStoreInvalidationCacheSyncIT.dbServer1.stringTable.getValueByKey("key"));
    }

    private void assertCleanCache() throws Exception {
        this.mc1.delete("key");
        this.mc2.delete("key");
        Assert.assertEquals((long)0L, (long)this.server1.getCacheManager("clustered").getCache("memcachedCache").getNumberOfEntries());
        Assert.assertEquals((long)0L, (long)this.server2.getCacheManager("clustered").getCache("memcachedCache").getNumberOfEntries());
        Assert.assertEquals((long)2L, (long)this.server1.getCacheManager("clustered").getClusterSize());
        Assert.assertEquals((long)2L, (long)this.server2.getCacheManager("clustered").getClusterSize());
    }

    @Override
    protected void dBServers() {
        StringBasedStoreInvalidationCacheSyncIT.dbServer1.connectionUrl = System.getProperty("connection.url");
        StringBasedStoreInvalidationCacheSyncIT.dbServer1.username = System.getProperty("username");
        StringBasedStoreInvalidationCacheSyncIT.dbServer1.password = System.getProperty("password");
        StringBasedStoreInvalidationCacheSyncIT.dbServer1.bucketTableName = null;
        StringBasedStoreInvalidationCacheSyncIT.dbServer1.stringTableName = "STRING_INVALIDATION_memcachedCache";
        StringBasedStoreInvalidationCacheSyncIT.dbServer2.connectionUrl = System.getProperty("connection.url");
        StringBasedStoreInvalidationCacheSyncIT.dbServer2.username = System.getProperty("username");
        StringBasedStoreInvalidationCacheSyncIT.dbServer2.password = System.getProperty("password");
        StringBasedStoreInvalidationCacheSyncIT.dbServer2.bucketTableName = null;
        StringBasedStoreInvalidationCacheSyncIT.dbServer2.stringTableName = "STRING_INVALIDATION_memcachedCache";
    }

    @Override
    protected String managerName() {
        return "clustered";
    }

    @Override
    protected String cacheName() {
        return "memcachedCache";
    }
}

