/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.jdbc;

import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.infinispan.server.test.util.jdbc.DBServer;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={CacheStore.class})
public class SingleNodeJdbcStoreIT {
    public static final Log log = LogFactory.getLog(SingleNodeJdbcStoreIT.class);
    public final String CONTAINER = "jdbc";
    @ArquillianResource
    protected ContainerController controller;
    @InfinispanResource(value="jdbc")
    protected RemoteInfinispanServer server;
    public final String ID_COLUMN_NAME = "id";
    public final String DATA_COLUMN_NAME = "datum";
    public static RemoteCacheManagerFactory rcmFactory;
    static DBServer stringDB;
    static DBServer stringWPDB;
    static DBServer stringAsyncDB;
    static RemoteInfinispanMBeans stringMBeans;
    static RemoteInfinispanMBeans stringWPMBeans;
    static RemoteCache stringCache;
    static RemoteCache stringWPCache;

    @BeforeClass
    public static void startup() {
        rcmFactory = new RemoteCacheManagerFactory();
    }

    @AfterClass
    public static void cleanup() {
        DBServer[] dbservers;
        for (DBServer dbServer : dbservers = new DBServer[]{stringDB, stringWPDB, stringAsyncDB}) {
            try {
                DBServer.TableManipulation bucketTable = dbServer.bucketTable;
                if (bucketTable == null || !bucketTable.getConnectionUrl().contains("db2")) continue;
                bucketTable.dropTable();
                if (dbServer.stringTable == null) continue;
                dbServer.stringTable.dropTable();
            }
            catch (Exception e) {
                log.trace((Object)"Couldn't drop the tables: ", (Throwable)e);
            }
        }
        if (rcmFactory != null) {
            rcmFactory.stopManagers();
        }
        rcmFactory = null;
    }

    @Before
    public void setUp() throws Exception {
        if (stringDB == null) {
            stringMBeans = ITestUtils.createMBeans(this.server, "jdbc", "stringWithPassivation", "local");
            stringCache = this.createCache(stringMBeans);
            stringDB = new DBServer(null, "STRING_WITH_PASSIVATION_" + SingleNodeJdbcStoreIT.stringMBeans.cacheName, "id", "datum");
            stringWPMBeans = ITestUtils.createMBeans(this.server, "jdbc", "stringNoPassivation", "local");
            stringWPCache = this.createCache(stringWPMBeans);
            stringWPDB = new DBServer(null, "STRING_NO_PASSIVATION_" + SingleNodeJdbcStoreIT.stringWPMBeans.cacheName, "id", "datum");
            stringAsyncDB = new DBServer(null, "STRING_ASYNC_memcachedCache", "id", "datum");
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc")})
    public void testNormalShutdown() throws Exception {
        this.testRestartStringStoreBefore();
        this.testRestartStringStoreWPBefore();
        this.controller.stop("jdbc");
        this.controller.start("jdbc");
        this.testRestartStringStoreAfter(false);
        this.testRestartStringStoreWPAfter();
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc")})
    public void testForcedShutdown() throws Exception {
        this.testRestartStringStoreBefore();
        this.testRestartStringStoreWPBefore();
        this.controller.kill("jdbc");
        this.controller.start("jdbc");
        this.testRestartStringStoreAfter(true);
        this.testRestartStringStoreWPAfter();
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="jdbc")})
    public void testAsyncStringStore() throws Exception {
        int i;
        MemcachedClient mc = ITestUtils.createMemcachedClient(this.server);
        int numEntries = 1000;
        for (i = 0; i != numEntries; ++i) {
            mc.set("key" + i, "value" + i);
        }
        ITestUtils.eventually(() -> SingleNodeJdbcStoreIT.stringAsyncDB.stringTable.exists(), 10000L);
        for (i = 0; i != numEntries; ++i) {
            Assert.assertNotNull((String)("key" + i + " was not found in DB in " + 15000L + " ms"), (Object)SingleNodeJdbcStoreIT.stringAsyncDB.stringTable.getValueByByteArrayKeyAwait("key" + i));
        }
        for (i = 0; i != numEntries; ++i) {
            mc.delete("key" + i);
        }
        ITestUtils.eventually(() -> SingleNodeJdbcStoreIT.stringAsyncDB.stringTable.getAllRows().isEmpty(), 10000L);
    }

    public void testRestartStringStoreBefore() throws Exception {
        this.assertCleanCacheAndStoreHotrod(stringCache, SingleNodeJdbcStoreIT.stringDB.stringTable);
        stringCache.put((Object)"k1", (Object)"v1");
        stringCache.put((Object)"k2", (Object)"v2");
        boolean tableExists = SingleNodeJdbcStoreIT.stringDB.stringTable.exists();
        if (tableExists) {
            Assert.assertNull((Object)SingleNodeJdbcStoreIT.stringDB.stringTable.getValueByKey(this.getStoredKey(stringCache, "k1")));
            Assert.assertNull((Object)SingleNodeJdbcStoreIT.stringDB.stringTable.getValueByKey(this.getStoredKey(stringCache, "k2")));
        }
        stringCache.put((Object)"k3", (Object)"v3");
        Assert.assertTrue((2L >= this.server.getCacheManager(SingleNodeJdbcStoreIT.stringMBeans.managerName).getCache(SingleNodeJdbcStoreIT.stringMBeans.cacheName).getNumberOfEntriesInMemory() ? 1 : 0) != 0);
        if (tableExists) {
            Assert.assertEquals((long)1L, (long)SingleNodeJdbcStoreIT.stringDB.stringTable.getAllKeys().size());
        }
    }

    public void testRestartStringStoreAfter(boolean killed) throws Exception {
        Assert.assertEquals((long)0L, (long)this.server.getCacheManager(SingleNodeJdbcStoreIT.stringMBeans.managerName).getCache(SingleNodeJdbcStoreIT.stringMBeans.cacheName).getNumberOfEntriesInMemory());
        if (killed) {
            List<String> passivatedKeys = SingleNodeJdbcStoreIT.stringDB.stringTable.getAllKeys();
            Assert.assertEquals((long)1L, (long)passivatedKeys.size());
            String passivatedKey = this.fromStoredKey(stringCache, passivatedKeys.get(0));
            Assert.assertEquals((Object)("v" + passivatedKey.substring(1)), (Object)stringCache.get((Object)passivatedKey));
            Assert.assertNull((Object)SingleNodeJdbcStoreIT.stringDB.stringTable.getValueByKey(this.getStoredKey(stringCache, passivatedKey)));
            HashSet<String> allKeys = new HashSet<String>(Arrays.asList("k1", "k2", "k3"));
            allKeys.remove(passivatedKey);
            for (String key : allKeys) {
                Assert.assertNull((Object)stringCache.get((Object)key));
            }
        } else {
            Assert.assertNotNull((Object)SingleNodeJdbcStoreIT.stringDB.stringTable.getValueByKey(this.getStoredKey(stringCache, "k1")));
            Assert.assertEquals((long)3L, (long)SingleNodeJdbcStoreIT.stringDB.stringTable.getAllRows().size());
            Assert.assertEquals((Object)"v1", (Object)stringCache.get((Object)"k1"));
            Assert.assertEquals((Object)"v2", (Object)stringCache.get((Object)"k2"));
            Assert.assertEquals((Object)"v3", (Object)stringCache.get((Object)"k3"));
            Assert.assertNull((Object)SingleNodeJdbcStoreIT.stringDB.stringTable.getValueByKey(this.getStoredKey(stringCache, "k3")));
        }
    }

    public void testRestartStringStoreWPBefore() throws Exception {
        this.assertCleanCacheAndStoreHotrod(stringWPCache, SingleNodeJdbcStoreIT.stringWPDB.stringTable);
        stringWPCache.put((Object)"k1", (Object)"v1");
        stringWPCache.put((Object)"k2", (Object)"v2");
        Assert.assertNotNull((Object)SingleNodeJdbcStoreIT.stringWPDB.stringTable.getValueByKey(this.getStoredKey(stringWPCache, "k1")));
        Assert.assertNotNull((Object)SingleNodeJdbcStoreIT.stringWPDB.stringTable.getValueByKey(this.getStoredKey(stringWPCache, "k2")));
    }

    public void testRestartStringStoreWPAfter() throws Exception {
        ITestUtils.eventually(() -> 2L == this.server.getCacheManager(SingleNodeJdbcStoreIT.stringWPMBeans.managerName).getCache(SingleNodeJdbcStoreIT.stringWPMBeans.cacheName).getNumberOfEntries(), 10000L);
        Assert.assertEquals((Object)"v1", (Object)stringWPCache.get((Object)"k1"));
        Assert.assertEquals((Object)"v2", (Object)stringWPCache.get((Object)"k2"));
        stringWPCache.remove((Object)"k1");
        Assert.assertNull((Object)SingleNodeJdbcStoreIT.stringWPDB.stringTable.getValueByKey(this.getStoredKey(stringWPCache, "k1")));
        Assert.assertNotNull((Object)SingleNodeJdbcStoreIT.stringWPDB.stringTable.getValueByKey(this.getStoredKey(stringWPCache, "k2")));
    }

    public void assertCleanCacheAndStoreHotrod(RemoteCache cache, DBServer.TableManipulation table) throws Exception {
        cache.clear();
        if (table.exists() && !table.getAllRows().isEmpty()) {
            table.deleteAllRows();
            ITestUtils.eventually(() -> table.getAllRows().isEmpty(), 10000L);
        }
    }

    public String getStoredKey(RemoteCache cache, String key) throws IOException, InterruptedException {
        return "\ufeff8" + Base64.getEncoder().encodeToString(cache.getRemoteCacheManager().getMarshaller().objectToByteBuffer((Object)key));
    }

    public String fromStoredKey(RemoteCache cache, String key) throws IOException, InterruptedException, ClassNotFoundException {
        Object o = cache.getRemoteCacheManager().getMarshaller().objectFromByteBuffer(Base64.getDecoder().decode(key.substring(2)));
        log.tracef("Key in DB=%s > %s", (Object)key, o);
        return (String)o;
    }

    public RemoteCache<Object, Object> createCache(RemoteInfinispanMBeans mbeans) {
        return rcmFactory.createCache(mbeans);
    }
}

