/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.router;

import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.server.test.category.Security;
import org.infinispan.server.test.client.rest.RESTHelper;
import org.infinispan.server.test.util.security.SecurityConfigurationHelper;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Security.class})
@WithRunningServer(value={@RunningServer(name="hotrodSslWithMultitenancy", config="testsuite/hotrod-ssl-with-multitenancy.xml")})
public class MultitenancyIT {
    public static final String CACHE_NAME = "cache-1";
    private static RemoteCache<String, Object> remoteCache = null;
    private static RemoteCacheManager remoteCacheManager = null;
    RESTHelper rest;

    @After
    public void release() {
        if (remoteCacheManager != null) {
            remoteCacheManager.stop();
        }
        this.rest.clearServers();
    }

    @Before
    public void init() {
        SecurityConfigurationHelper builder = new SecurityConfigurationHelper().withDefaultSsl().withSni("sni1");
        builder.addServer().host("127.0.0.1").port(11222);
        remoteCacheManager = new RemoteCacheManager(builder.build());
        remoteCache = remoteCacheManager.getCache(CACHE_NAME);
        this.rest = new RESTHelper();
        this.rest.addServer("127.0.0.1", 8080, "/rest/multi-tenancy-1");
    }

    @Test
    public void testWritesThroughHotrodAndReadsThroughREST() throws Exception {
        remoteCache.put((Object)"hello", (Object)"Infinispan!");
        this.rest.get(this.rest.fullPathKey(CACHE_NAME, "hello"), "Infinispan!", 200, true, "Accept", "text/plain");
    }
}

