/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.rest;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.server.test.category.RESTClusteredDomain;
import org.infinispan.server.test.client.rest.AbstractRESTClusteredIT;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.ManagementClient;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={RESTClusteredDomain.class})
public class RESTClusteredDomainIT
extends AbstractRESTClusteredIT {
    private static final int REST_PORT1 = 8081;
    private static final int REST_PORT2 = 8231;
    @InfinispanResource(value="master:server-one", jmxPort=4447)
    RemoteInfinispanServer server1;
    @InfinispanResource(value="master:server-two", jmxPort=4597)
    RemoteInfinispanServer server2;

    @BeforeClass
    public static void beforeClass() throws Exception {
        ManagementClient client = ManagementClient.getInstance();
        client.enableJmx();
        if (ITestUtils.isReplicatedMode()) {
            client.addSocketBinding("rest-repl", "clustered-sockets", 8081);
            client.addReplicatedCache("restReplCache", "clustered", "replicated");
            client.addRestEndpoint("restRepl", "clustered", "restReplCache", "rest-repl");
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        ManagementClient client = ManagementClient.getInstance();
        if (ITestUtils.isReplicatedMode()) {
            client.removeRestEndpoint("restRepl");
            client.removeReplicatedCache("restReplCache", "clustered");
            client.removeSocketBinding("rest-repl", "clustered-sockets");
        }
        client.disableJmx();
    }

    @Override
    protected List<RemoteInfinispanServer> getServers() {
        return Collections.unmodifiableList(Arrays.asList(this.server1, this.server2));
    }

    @Override
    protected int getRestPort1() {
        return 8081;
    }

    @Override
    protected int getRestPort2() {
        return 8231;
    }
}

