/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.rest;

import java.io.File;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpResponse;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.server.test.category.Security;
import org.infinispan.server.test.client.rest.RESTHelper;
import org.infinispan.server.test.util.ITestUtils;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Security.class})
@WithRunningServer(value={@RunningServer(name="restSslWithSni")})
public class RESTClientWithSniEncryptionIT {
    protected static final String DEFAULT_TRUSTSTORE_PATH = ITestUtils.SERVER_CONFIG_DIR + File.separator + "ca.jks";
    protected static final String DEFAULT_TRUSTSTORE_PASSWORD = "secret";
    @InfinispanResource(value="restSslWithSni")
    RemoteInfinispanServer ispnServer;
    RESTHelper rest;

    @Before
    public void setup() {
        this.rest = new RESTHelper();
        this.rest.addServer(this.ispnServer.getRESTEndpoint().getInetAddress().getHostName(), this.ispnServer.getRESTEndpoint().getContextPath());
    }

    @After
    public void release() {
        this.rest.clearServers();
    }

    @Test
    public void testUnauthorizedAccessToDefaultSSLContext() throws Exception {
        SSLContext sslContext = SslContextFactory.getContext(null, null, (String)DEFAULT_TRUSTSTORE_PATH, (char[])DEFAULT_TRUSTSTORE_PASSWORD.toCharArray());
        this.rest.setSni(sslContext, Optional.empty());
        try {
            this.rest.put(this.rest.toSsl(this.rest.fullPathKey("test")), "test", "text/plain");
            Assert.fail((String)"REST PUT operation should have failed with SSLHandshakeException");
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            // empty catch block
        }
    }

    @Test
    public void testAuthorizedAccessThroughSni() throws Exception {
        SSLContext sslContext = SslContextFactory.getContext(null, null, (String)DEFAULT_TRUSTSTORE_PATH, (char[])DEFAULT_TRUSTSTORE_PASSWORD.toCharArray());
        this.rest.setSni(sslContext, Optional.of("sni"));
        HttpResponse response = this.rest.put(this.rest.toSsl(this.rest.fullPathKey("test")), "test", "text/plain");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
    }
}

