/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.rest;

import java.net.URI;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpUriRequest;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.server.test.category.RESTSingleNode;
import org.infinispan.server.test.client.rest.AbstractRESTClientIT;
import org.jboss.arquillian.junit.Arquillian;
import org.jgroups.util.Util;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={RESTSingleNode.class})
public class RESTClientIT
extends AbstractRESTClientIT {
    @InfinispanResource(value="container1")
    RemoteInfinispanServer server1;

    @Override
    protected void addRestServer() {
        this.rest.addServer(this.server1.getRESTEndpoint().getInetAddress().getHostName(), this.server1.getRESTEndpoint().getContextPath());
    }

    @Test
    public void testSimpleCORSRequest() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("cors_key");
        HttpGet get = new HttpGet(fullPathKey);
        get.addHeader("Origin", "http://host1");
        CloseableHttpResponse resp = this.rest.client.execute((HttpUriRequest)get);
        Header allowOriginHeader = resp.getFirstHeader("access-control-allow-origin");
        Assert.assertNotNull((Object)allowOriginHeader);
        Assert.assertEquals((Object)"http://host1", (Object)allowOriginHeader.getValue());
    }

    @Test
    public void testPreflightCORSRequest() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("cors_preflight_key");
        HttpOptions options = new HttpOptions(fullPathKey);
        options.addHeader("Origin", "http://whatever");
        options.addHeader("Access-Control-Request-Method", "PUT");
        options.addHeader("Access-Control-Request-Headers", "Key-Content-Type");
        CloseableHttpResponse resp = this.rest.client.execute((HttpUriRequest)options);
        Assert.assertEquals((Object)"*", (Object)resp.getFirstHeader("access-control-allow-origin").getValue());
        String value = resp.getFirstHeader("access-control-allow-methods").getValue();
        Util.assertTrue((boolean)value.contains("GET"));
        Util.assertTrue((boolean)value.contains("POST"));
        Util.assertTrue((boolean)value.contains("PUT"));
        Assert.assertEquals((Object)"Key-Content-Type", (Object)resp.getFirstHeader("access-control-allow-headers").getValue());
    }
}

