/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.rest;

import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.server.test.category.RESTSingleNodeDomain;
import org.infinispan.server.test.client.rest.AbstractRESTClientIT;
import org.infinispan.server.test.util.ManagementClient;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={RESTSingleNodeDomain.class})
public class RESTClientDomainIT
extends AbstractRESTClientIT {
    private static final int REST_PORT = 8082;
    @InfinispanResource(value="master:server-one", jmxPort=4447)
    RemoteInfinispanServer server1;

    @BeforeClass
    public static void beforeClass() throws Exception {
        ManagementClient client = ManagementClient.getInstance();
        client.enableJmx();
        client.addSocketBinding("rest-local", "clustered-sockets", 8082);
        client.addLocalCache("restLocalCache", "clustered", "localCacheConfiguration");
        client.addLocalCache("restNamedCache", "clustered", "localCacheConfiguration");
        client.addRestEndpoint("restLocal", "clustered", "restLocalCache", "rest-local");
    }

    @AfterClass
    public static void afterClass() throws Exception {
        ManagementClient client = ManagementClient.getInstance();
        client.removeRestEndpoint("restLocal");
        client.removeLocalCache("restNamedCache", "clustered");
        client.removeLocalCache("restLocalCache", "clustered");
        client.removeLocalCacheConfiguration("localCacheConfiguration", "clustered");
        client.removeSocketBinding("rest-local", "clustered-sockets");
        client.disableJmx();
    }

    @Override
    protected void addRestServer() {
        this.rest.addServer(this.server1.getRESTEndpoint().getInetAddress().getHostName(), 8082, this.server1.getRESTEndpoint().getContextPath());
    }
}

