/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.rest;

import java.util.List;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.server.test.client.rest.RESTHelper;
import org.infinispan.server.test.util.ITestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractRESTClusteredIT {
    protected RESTHelper rest;

    protected abstract int getRestPort1();

    protected abstract int getRestPort2();

    protected abstract List<RemoteInfinispanServer> getServers();

    @Before
    public void setUp() throws Exception {
        this.rest = new RESTHelper();
        if (ITestUtils.isReplicatedMode()) {
            this.rest.addServer(this.getServers().get(0).getRESTEndpoint().getInetAddress().getHostName(), this.getRestPort1(), this.getServers().get(0).getRESTEndpoint().getContextPath());
            this.rest.addServer(this.getServers().get(1).getRESTEndpoint().getInetAddress().getHostName(), this.getRestPort2(), this.getServers().get(1).getRESTEndpoint().getContextPath());
        } else {
            this.rest.addServer(this.getServers().get(0).getRESTEndpoint().getInetAddress().getHostName(), this.getServers().get(0).getRESTEndpoint().getContextPath());
            this.rest.addServer(this.getServers().get(1).getRESTEndpoint().getInetAddress().getHostName(), this.getServers().get(1).getRESTEndpoint().getContextPath());
        }
        this.rest.delete(this.rest.fullPathKey("a"));
        this.rest.delete(this.rest.fullPathKey("b"));
        this.rest.delete(this.rest.fullPathKey("c"));
        this.rest.head(this.rest.fullPathKey("a"), 404);
        this.rest.head(this.rest.fullPathKey("b"), 404);
        this.rest.head(this.rest.fullPathKey("c"), 404);
    }

    @After
    public void tearDown() throws Exception {
        this.rest.delete(this.rest.fullPathKey("a"));
        this.rest.delete(this.rest.fullPathKey("b"));
        this.rest.delete(this.rest.fullPathKey("c"));
        this.rest.clearServers();
    }

    @Test
    public void testReplicationPut() throws Exception {
        this.rest.put(this.rest.fullPathKey(0, "a"), "data", "text/plain");
        this.rest.get(this.rest.fullPathKey(1, "a"), "data");
    }

    @Test
    public void testReplicationPost() throws Exception {
        this.rest.post(this.rest.fullPathKey(0, "a"), "data", "text/plain");
        this.rest.get(this.rest.fullPathKey(1, "a"), "data");
    }

    @Test
    public void testReplicationDelete() throws Exception {
        this.rest.post(this.rest.fullPathKey(0, "a"), "data", "text/plain");
        this.rest.get(this.rest.fullPathKey(1, "a"), "data");
        this.rest.delete(this.rest.fullPathKey(0, "a"));
        this.rest.head(this.rest.fullPathKey(1, "a"), 404);
    }

    @Test
    public void testReplicationWipeCache() throws Exception {
        this.rest.post(this.rest.fullPathKey(0, "a"), "data", "text/plain");
        this.rest.post(this.rest.fullPathKey(0, "b"), "data", "text/plain");
        this.rest.head(this.rest.fullPathKey(0, "a"));
        this.rest.head(this.rest.fullPathKey(0, "b"));
        this.rest.delete(this.rest.fullPathKey(0, null));
        this.rest.head(this.rest.fullPathKey(1, "a"), 404);
        this.rest.head(this.rest.fullPathKey(1, "b"), 404);
    }

    @Test
    public void testReplicationTTL() throws Exception {
        this.rest.post(this.rest.fullPathKey(0, "a"), "data", "text/plain", 200, "Content-Type", "text/plain", "timeToLiveSeconds", "2");
        this.rest.head(this.rest.fullPathKey(1, "a"));
        ITestUtils.sleepForSecs(2.1);
        this.rest.head(this.rest.fullPathKey(1, "a"), 404);
    }
}

