/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod.security;

import javax.net.ssl.SSLHandshakeException;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.server.test.category.Security;
import org.infinispan.server.test.util.security.SecurityConfigurationHelper;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Security.class})
@WithRunningServer(value={@RunningServer(name="hotrodSslWithSni", config="testsuite/hotrod-ssl-with-sni.xml")})
public class HotRodSslWithSniEncryptionIT {
    protected static RemoteCache<String, String> remoteCache = null;
    protected static RemoteCacheManager remoteCacheManager = null;
    @InfinispanResource(value="hotrodSslWithSni")
    RemoteInfinispanServer ispnServer;

    @After
    public void release() {
        if (remoteCacheManager != null) {
            remoteCacheManager.stop();
        }
    }

    @Test
    public void testUnauthorizedAccessToDefaultSSLContext() throws Exception {
        SecurityConfigurationHelper builder = new SecurityConfigurationHelper().withDefaultSsl();
        String hostname = this.ispnServer.getHotrodEndpoint().getInetAddress().getHostName();
        builder.addServer().host(hostname).port(this.ispnServer.getHotrodEndpoint().getPort());
        remoteCacheManager = new RemoteCacheManager(builder.build());
        try {
            remoteCacheManager.getCache("___defaultcache");
        }
        catch (TransportException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof SSLHandshakeException));
        }
    }

    @Test
    public void testAuthorizedAccessThroughSni() throws Exception {
        SecurityConfigurationHelper builder = new SecurityConfigurationHelper().withDefaultSsl().withSni("sni");
        String hostname = this.ispnServer.getHotrodEndpoint().getInetAddress().getHostName();
        builder.addServer().host(hostname).port(this.ispnServer.getHotrodEndpoint().getPort());
        remoteCacheManager = new RemoteCacheManager(builder.build());
        remoteCache = remoteCacheManager.getCache("___defaultcache");
        Assert.assertNotNull(remoteCache);
    }
}

