/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod.security;

import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.ServerStatistics;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.junit.Assert;

public class HotRodAuthzOperationTests {
    public static final String KEY1 = "key1";
    public static final String VALUE1 = "value1";
    public static final String KEY2 = "key2";
    public static final String VALUE2 = "value2";
    public static final String NON_EXISTENT_KEY = "nonExistentKey";
    public static final int ASYNC_TIMEOUT = 1;

    public static void testClear(RemoteCache<String, String> remoteCache) {
        remoteCache.clear();
        Assert.assertTrue((boolean)remoteCache.isEmpty());
    }

    public static void testClearAsync(RemoteCache<String, String> remoteCache) throws Exception {
        CompletableFuture f = remoteCache.clearAsync();
        f.get(1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)remoteCache.isEmpty());
    }

    public static void testPutClear(RemoteCache<String, String> remoteCache) {
        remoteCache.put((Object)KEY1, (Object)VALUE1);
        remoteCache.put((Object)KEY2, (Object)VALUE2);
        remoteCache.clear();
        Assert.assertFalse((boolean)remoteCache.containsKey((Object)KEY1));
        Assert.assertFalse((boolean)remoteCache.containsKey((Object)KEY2));
        Assert.assertTrue((boolean)remoteCache.isEmpty());
    }

    public static void testPutClearAsync(RemoteCache<String, String> remoteCache) throws Exception {
        CompletableFuture f1 = remoteCache.putAsync((Object)KEY1, (Object)VALUE1);
        CompletableFuture f2 = remoteCache.putAsync((Object)KEY2, (Object)VALUE2);
        f1.get(1L, TimeUnit.SECONDS);
        f2.get(1L, TimeUnit.SECONDS);
        CompletableFuture c = remoteCache.clearAsync();
        c.get(1L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)remoteCache.containsKey((Object)KEY1));
        Assert.assertFalse((boolean)remoteCache.containsKey((Object)KEY2));
        Assert.assertTrue((boolean)remoteCache.isEmpty());
    }

    public static void testContainsKey(RemoteCache<String, String> remoteCache) {
        Assert.assertFalse((boolean)remoteCache.containsKey((Object)NON_EXISTENT_KEY));
    }

    public static void testPutContainsKey(RemoteCache<String, String> remoteCache) {
        remoteCache.put((Object)KEY1, (Object)VALUE1);
        Assert.assertTrue((boolean)remoteCache.containsKey((Object)KEY1));
    }

    public static void testGet(RemoteCache<String, String> remoteCache) {
        Assert.assertTrue((boolean)remoteCache.containsKey((Object)KEY1));
        Assert.assertEquals((Object)VALUE1, (Object)remoteCache.get((Object)KEY1));
    }

    public static void testGetAsync(RemoteCache<String, String> remoteCache) throws Exception {
        Assert.assertTrue((boolean)remoteCache.containsKey((Object)KEY1));
        CompletableFuture f = remoteCache.getAsync((Object)KEY1);
        Assert.assertEquals((Object)VALUE1, f.get(1L, TimeUnit.SECONDS));
    }

    public static void testGetNonExistent(RemoteCache<String, String> remoteCache) {
        Assert.assertEquals(null, (Object)remoteCache.get((Object)NON_EXISTENT_KEY));
    }

    public static void testGetNonExistentAsync(RemoteCache<String, String> remoteCache) throws Exception {
        Assert.assertEquals(null, remoteCache.getAsync((Object)NON_EXISTENT_KEY).get(1L, TimeUnit.SECONDS));
    }

    public static void testKeySet(RemoteCache<String, String> remoteCache) {
        remoteCache.clear();
        remoteCache.put((Object)KEY1, (Object)VALUE1);
        remoteCache.put((Object)KEY2, (Object)VALUE2);
        Assert.assertEquals((long)2L, (long)remoteCache.keySet().size());
    }

    public static void testPut(RemoteCache<String, String> remoteCache) {
        Assert.assertNull((Object)remoteCache.put((Object)KEY1, (Object)VALUE1));
    }

    public static void testPutAsync(RemoteCache<String, String> remoteCache) throws Exception {
        CompletableFuture f = remoteCache.putAsync((Object)KEY1, (Object)VALUE1);
        Assert.assertNull(f.get(1L, TimeUnit.SECONDS));
    }

    public static void testPutGet(RemoteCache<String, String> remoteCache) {
        HotRodAuthzOperationTests.testPut(remoteCache);
        HotRodAuthzOperationTests.testGet(remoteCache);
    }

    public static void testPutGetAsync(RemoteCache<String, String> remoteCache) throws Exception {
        HotRodAuthzOperationTests.testPutAsync(remoteCache);
        HotRodAuthzOperationTests.testGetAsync(remoteCache);
    }

    public static void testPutAll(RemoteCache<String, String> remoteCache) {
        remoteCache.clear();
        HashMap<String, String> entries = new HashMap<String, String>(2);
        entries.put(KEY1, VALUE1);
        entries.put(KEY2, VALUE2);
        remoteCache.putAll(entries);
        Assert.assertEquals((long)2L, (long)remoteCache.size());
    }

    public static void testPutAllAsync(RemoteCache<String, String> remoteCache) throws Exception {
        remoteCache.clear();
        HashMap<String, String> entries = new HashMap<String, String>(2);
        entries.put(KEY1, VALUE1);
        entries.put(KEY2, VALUE2);
        CompletableFuture f = remoteCache.putAllAsync(entries);
        f.get(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)remoteCache.size());
    }

    public static void testRemove(RemoteCache<String, String> remoteCache) {
        Assert.assertNull((Object)remoteCache.remove((Object)NON_EXISTENT_KEY));
    }

    public static void testRemoveAsync(RemoteCache<String, String> remoteCache) throws Exception {
        Assert.assertNull(remoteCache.removeAsync((Object)NON_EXISTENT_KEY).get(1L, TimeUnit.SECONDS));
    }

    public static void testRemoveContains(RemoteCache<String, String> remoteCache) {
        remoteCache.put((Object)KEY1, (Object)VALUE1);
        Assert.assertTrue((boolean)remoteCache.containsKey((Object)KEY1));
        remoteCache.remove((Object)KEY1);
        Assert.assertFalse((boolean)remoteCache.containsKey((Object)KEY1));
    }

    public static void testRemoveContainsAsync(RemoteCache<String, String> remoteCache) throws Exception {
        remoteCache.put((Object)KEY1, (Object)VALUE1);
        Assert.assertTrue((boolean)remoteCache.containsKey((Object)KEY1));
        CompletableFuture f = remoteCache.removeAsync((Object)KEY1);
        f.get(1L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)remoteCache.containsKey((Object)KEY1));
    }

    public static void testSize(RemoteCache<String, String> remoteCache) {
        Assert.assertTrue((remoteCache.size() > 0 ? 1 : 0) != 0);
    }

    public static void testPutIfAbsent(RemoteCache<String, String> remoteCache) {
        remoteCache.clear();
        remoteCache.put((Object)KEY1, (Object)VALUE1);
        Assert.assertNull((Object)remoteCache.putIfAbsent((Object)KEY1, (Object)"some test value"));
        Assert.assertEquals((Object)VALUE1, (Object)remoteCache.get((Object)KEY1));
    }

    public static void testPutIfAbsentAsync(RemoteCache<String, String> remoteCache) throws Exception {
        remoteCache.clear();
        remoteCache.put((Object)KEY1, (Object)VALUE1);
        Assert.assertNull(remoteCache.putIfAbsentAsync((Object)KEY1, (Object)"some test value").get(1L, TimeUnit.SECONDS));
        Assert.assertEquals((Object)VALUE1, remoteCache.getAsync((Object)KEY1).get(1L, TimeUnit.SECONDS));
    }

    public static void testReplaceWithFlag(RemoteCache<String, String> remoteCache) {
        remoteCache.put((Object)KEY1, (Object)VALUE1);
        Assert.assertEquals((Object)VALUE1, (Object)remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).replace((Object)KEY1, (Object)"replace value"));
    }

    public static void testReplaceWitFlagAsync(RemoteCache<String, String> remoteCache) throws Exception {
        remoteCache.put((Object)KEY1, (Object)VALUE1);
        Assert.assertEquals((Object)VALUE1, remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).replaceAsync((Object)KEY1, (Object)"replace value").get(1L, TimeUnit.SECONDS));
    }

    public static void testPutGetBulk(RemoteCache<String, String> remoteCache) {
        remoteCache.clear();
        remoteCache.put((Object)KEY1, (Object)VALUE1);
        remoteCache.put((Object)KEY2, (Object)VALUE2);
        Assert.assertEquals((long)2L, (long)remoteCache.getBulk().size());
    }

    public static void testGetWithMetadata(RemoteCache<String, String> remoteCache) {
        Assert.assertNull((Object)remoteCache.getWithMetadata((Object)NON_EXISTENT_KEY));
    }

    public static void testPutGetWithMetadata(RemoteCache<String, String> remoteCache) {
        remoteCache.put((Object)KEY1, (Object)VALUE1);
        Assert.assertNotNull((Object)remoteCache.getWithMetadata((Object)KEY1));
    }

    public static void testGetVersioned(RemoteCache<String, String> remoteCache) {
        Assert.assertNull((Object)remoteCache.getVersioned((Object)NON_EXISTENT_KEY));
    }

    public static void testPutGetVersioned(RemoteCache<String, String> remoteCache) {
        remoteCache.clear();
        remoteCache.put((Object)KEY1, (Object)VALUE1);
        VersionedValue v = remoteCache.getVersioned((Object)KEY1);
        Assert.assertEquals((Object)VALUE1, (Object)v.getValue());
        Assert.assertTrue((v.getVersion() != 0L ? 1 : 0) != 0);
    }

    public static void testReplaceWithVersioned(RemoteCache<String, String> remoteCache) {
        remoteCache.clear();
        remoteCache.put((Object)KEY1, (Object)VALUE1);
        VersionedValue v = remoteCache.getVersioned((Object)KEY1);
        Assert.assertEquals((Object)VALUE1, (Object)v.getValue());
        long ver = v.getVersion();
        remoteCache.replaceWithVersion((Object)KEY1, (Object)VALUE2, ver);
        v = remoteCache.getVersioned((Object)KEY1);
        Assert.assertEquals((Object)VALUE2, (Object)v.getValue());
        Assert.assertTrue((ver != v.getVersion() ? 1 : 0) != 0);
    }

    public static void testReplaceWithVersionAsync(RemoteCache<String, String> remoteCache) throws Exception {
        remoteCache.clear();
        remoteCache.put((Object)KEY1, (Object)VALUE1);
        VersionedValue v = remoteCache.getVersioned((Object)KEY1);
        Assert.assertEquals((Object)VALUE1, (Object)v.getValue());
        long ver = v.getVersion();
        CompletableFuture f = remoteCache.replaceWithVersionAsync((Object)KEY1, (Object)VALUE2, ver);
        f.get(1L, TimeUnit.SECONDS);
        v = remoteCache.getVersioned((Object)KEY1);
        Assert.assertEquals((Object)VALUE2, (Object)v.getValue());
        Assert.assertTrue((ver != v.getVersion() ? 1 : 0) != 0);
    }

    public static void testRemoveWithVersion(RemoteCache<String, String> remoteCache) {
        remoteCache.clear();
        remoteCache.put((Object)KEY1, (Object)VALUE1);
        VersionedValue v = remoteCache.getVersioned((Object)KEY1);
        Assert.assertEquals((Object)VALUE1, (Object)v.getValue());
        long ver = v.getVersion();
        remoteCache.removeWithVersion((Object)KEY1, ver);
        v = remoteCache.getVersioned((Object)KEY1);
        if (v != null) {
            Assert.assertTrue((ver != v.getVersion() ? 1 : 0) != 0);
        }
    }

    public static void testRemoveWithVersionAsync(RemoteCache<String, String> remoteCache) throws Exception {
        remoteCache.clear();
        remoteCache.put((Object)KEY1, (Object)VALUE1);
        VersionedValue v = remoteCache.getVersioned((Object)KEY1);
        Assert.assertEquals((Object)VALUE1, (Object)v.getValue());
        long ver = v.getVersion();
        CompletableFuture f = remoteCache.removeWithVersionAsync((Object)KEY1, ver);
        f.get(1L, TimeUnit.SECONDS);
        v = remoteCache.getVersioned((Object)KEY1);
        if (v != null) {
            Assert.assertTrue((ver != v.getVersion() ? 1 : 0) != 0);
        }
    }

    public static void testStats(RemoteCache<String, String> remoteCache) {
        ServerStatistics s = remoteCache.stats();
        Assert.assertNotNull((Object)s);
    }

    public static void testGetRemoteCacheManager(RemoteCache<String, String> remoteCache) {
        RemoteCacheManager rcm = remoteCache.getRemoteCacheManager();
        Assert.assertNotNull((Object)rcm);
    }

    public static void testAddGetClientListener(RemoteCache<String, String> remoteCache) {
        remoteCache.addClientListener((Object)new NoopEventListener());
        Set s = remoteCache.getListeners();
        Assert.assertTrue((s.size() > 0 ? 1 : 0) != 0);
    }

    public static void testRemoveClientListener(RemoteCache<String, String> remoteCache) {
        NoopEventListener c = new NoopEventListener();
        int initialListenerCount = remoteCache.getListeners().size();
        remoteCache.addClientListener((Object)c);
        Assert.assertEquals((long)(initialListenerCount + 1), (long)remoteCache.getListeners().size());
        remoteCache.removeClientListener((Object)c);
        Assert.assertEquals((long)initialListenerCount, (long)remoteCache.getListeners().size());
    }

    @ClientListener
    public static class NoopEventListener {
        @ClientCacheEntryCreated
        public void handleCreatedEvent(ClientCacheEntryCreatedEvent<?> e) {
        }

        @ClientCacheEntryModified
        public void handleModifiedEvent(ClientCacheEntryModifiedEvent<?> e) {
        }

        @ClientCacheEntryRemoved
        public void handleRemovedEvent(ClientCacheEntryRemovedEvent<?> e) {
        }
    }
}

