/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.server.test.category.HotRodSingleNode;
import org.infinispan.test.TestingUtil;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={HotRodSingleNode.class})
public class ScriptExecIT {
    private static final String SCRIPT_CACHE_NAME = "___script_cache";
    private static final String COMPATIBILITY_CACHE_NAME = "compatibilityCache";
    private static final String STREAM = "stream.js";
    static RemoteCacheManager remoteCacheManager;
    RemoteCache<Integer, String> remoteCache;
    RemoteCache<String, String> scriptCache;
    @InfinispanResource(value="container1")
    RemoteInfinispanServer server1;
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Before
    public void initialize() {
        if (remoteCacheManager == null || !remoteCacheManager.isStarted()) {
            Configuration config = this.createRemoteCacheManagerConfiguration();
            remoteCacheManager = new RemoteCacheManager(config, true);
        }
        this.scriptCache = remoteCacheManager.getCache(SCRIPT_CACHE_NAME);
        this.remoteCache = remoteCacheManager.getCache();
    }

    @After
    public void clearCache() {
        this.remoteCache.clear();
        remoteCacheManager.getCache(COMPATIBILITY_CACHE_NAME).clear();
    }

    protected ProtocolVersion getProtocolVersion() {
        return ProtocolVersion.DEFAULT_PROTOCOL_VERSION;
    }

    private Configuration createRemoteCacheManagerConfiguration() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.version(this.getProtocolVersion());
        config.addServer().host(this.server1.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server1.getHotrodEndpoint().getPort());
        return config.build();
    }

    @Test
    public void testRemovingNonExistentScript() {
        this.exceptionRule.expect(HotRodClientException.class);
        this.exceptionRule.expectMessage("Unknown task");
        this.remoteCache.execute("nonExistent.js", new HashMap());
    }

    @Test
    public void testSimpleScriptExecutionWithParams() throws IOException {
        RemoteCache remoteCache = remoteCacheManager.getCache(COMPATIBILITY_CACHE_NAME);
        this.addScripts("test.js");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("key", "parameter");
        parameters.put("value", "value");
        int result = (Integer)remoteCache.execute("test.js", parameters);
        Assert.assertEquals((long)1L, (long)result);
        Assert.assertEquals((Object)"value", (Object)remoteCache.get((Object)"parameter"));
    }

    @Test
    public void testMapReduceScriptExecution() throws IOException {
        RemoteCache remoteCache = remoteCacheManager.getCache(COMPATIBILITY_CACHE_NAME);
        this.addScripts("stream_serverTask.js");
        remoteCache.put((Object)"1", (Object)"word1 word2 word3");
        remoteCache.put((Object)"2", (Object)"word1 word2");
        remoteCache.put((Object)"3", (Object)"word1");
        Map results = (Map)remoteCache.execute("stream_serverTask.js", Collections.emptyMap());
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertTrue((boolean)((Long)results.get("word1")).equals(3L));
        Assert.assertTrue((boolean)((Long)results.get("word2")).equals(2L));
        Assert.assertTrue((boolean)((Long)results.get("word3")).equals(1L));
    }

    @Test
    public void testScriptExecution() throws Exception {
        this.remoteCache.clear();
        this.remoteCache.put((Object)1, (Object)"word1 word2 word3");
        this.remoteCache.put((Object)2, (Object)"word1 word2");
        this.remoteCache.put((Object)3, (Object)"word1");
        this.addScripts(STREAM);
        Map results = (Map)this.remoteCache.execute(STREAM, Collections.emptyMap());
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertTrue((boolean)((Long)results.get("word1")).equals(3L));
        Assert.assertTrue((boolean)((Long)results.get("word2")).equals(2L));
        Assert.assertTrue((boolean)((Long)results.get("word3")).equals(1L));
    }

    private void addScripts(String ... scripts) throws IOException {
        for (String script : scripts) {
            try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(script);){
                this.scriptCache.put((Object)script, (Object)TestingUtil.loadFileAsString((InputStream)in));
            }
        }
    }

    @AfterClass
    public static void release() {
        if (remoteCacheManager != null) {
            remoteCacheManager.stop();
        }
    }
}

