/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import javax.transaction.TransactionManager;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.transaction.lookup.RemoteTransactionManagerLookup;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.XMLStringConfiguration;
import org.infinispan.server.test.category.HotRodClustered;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={HotRodClustered.class})
public class HotRodTransactionalCacheIT {
    private static final String TEST_CACHE_XML_CONFIG = "<infinispan><cache-container>  <distributed-cache-configuration name=\"%s\">    <locking isolation=\"REPEATABLE_READ\"/>    <transaction locking=\"PESSIMISTIC\" mode=\"%s\" />  </distributed-cache-configuration></cache-container></infinispan>";
    @InfinispanResource(value="container1")
    RemoteInfinispanServer server1;
    private RemoteCacheManager remoteCacheManager;

    @Before
    public void initialize() {
        if (this.remoteCacheManager == null) {
            Configuration config = this.createRemoteCacheManagerConfiguration();
            this.remoteCacheManager = new RemoteCacheManager(config, true);
        }
    }

    @Test
    public void testCommitAndRollbackWithUserDefinedSyncMode() throws Exception {
        this.createCache("user-sync-tx-cache", "NON_XA");
        this.doTest("user-sync-tx-cache");
    }

    @Test
    public void testCommitAndRollbackWithUserDefinedXaMode() throws Exception {
        this.createCache("user-xa-tx-cache", "NON_DURABLE_XA");
        this.doTest("user-xa-tx-cache");
    }

    @Test
    public void testCommitAndRollbackWithUserDefinedFullXaMode() throws Exception {
        this.createCache("user-full-xa-tx-cache", "FULL_XA");
        this.doTest("user-full-xa-tx-cache");
    }

    @Test
    public void testCommitAndRollbackWithServerDefinedSyncMode() throws Exception {
        this.doTest("SyncTxCache");
    }

    @Test
    public void testCommitAndRollbackWithServerDefinedXaMode() throws Exception {
        this.doTest("XaTxCache");
    }

    @Test
    public void testCommitAndRollbackWithServerDefinedFullXaMode() throws Exception {
        this.doTest("FullXaTxCache");
    }

    private void doTest(String cacheName) throws Exception {
        RemoteCache cache = this.remoteCacheManager.getCache(cacheName);
        TransactionManager tm = cache.getTransactionManager();
        tm.begin();
        cache.put((Object)"k", (Object)"v1");
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k"));
        tm.commit();
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k"));
        tm.begin();
        cache.put((Object)"k", (Object)"v2");
        cache.put((Object)"k2", (Object)"v1");
        Assert.assertEquals((Object)"v2", (Object)cache.get((Object)"k"));
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k2"));
        tm.rollback();
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k"));
        Assert.assertNull((Object)cache.get((Object)"k2"));
    }

    private void createCache(String cacheName, String transactionMode) {
        String xml = String.format(TEST_CACHE_XML_CONFIG, cacheName, transactionMode);
        this.remoteCacheManager.administration().createCache(cacheName, (BasicConfiguration)new XMLStringConfiguration(xml));
    }

    private Configuration createRemoteCacheManagerConfiguration() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.addServer().host(this.server1.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server1.getHotrodEndpoint().getPort());
        config.transaction().transactionMode(TransactionMode.NON_XA);
        config.transaction().transactionManagerLookup(RemoteTransactionManagerLookup.getInstance());
        return config.build();
    }
}

