/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.server.test.category.HotRodClusteredDomain;
import org.infinispan.server.test.client.hotrod.AbstractRemoteCacheIT;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.ManagementClient;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={HotRodClusteredDomain.class})
public class HotRodRemoteCacheDomainIT
extends AbstractRemoteCacheIT {
    @InfinispanResource(value="master:server-one", jmxPort=4447)
    RemoteInfinispanServer server1;
    @InfinispanResource(value="master:server-two", jmxPort=4597)
    RemoteInfinispanServer server2;

    @Deployment(testable=false, name="filter-1")
    @TargetsContainer(value="cluster")
    public static Archive<?> deployFilter1() {
        return HotRodRemoteCacheDomainIT.createFilterArchive();
    }

    @Deployment(testable=false, name="converter-1")
    @TargetsContainer(value="cluster")
    public static Archive<?> deployConverter1() {
        return HotRodRemoteCacheDomainIT.createConverterArchive();
    }

    @Deployment(testable=false, name="filter-converter-1")
    @TargetsContainer(value="cluster")
    public static Archive<?> deployFilterConverter1() {
        return HotRodRemoteCacheDomainIT.createFilterConverterArchive();
    }

    @Deployment(testable=false, name="key-value-filter-converter-1")
    @TargetsContainer(value="cluster")
    public static Archive<?> deployKeyValueFilterConverter1() {
        return HotRodRemoteCacheDomainIT.createKeyValueFilterConverterArchive();
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        ManagementClient client = ManagementClient.getInstance();
        client.enableJmx();
        if (ITestUtils.isDistributedMode()) {
            testCache = "distTestCache";
            client.addDistributedCacheConfiguration("distCacheConfiguration", "clustered");
            client.addDistributedCache(testCache, "clustered", "distCacheConfiguration");
        } else if (ITestUtils.isLocalMode()) {
            String targetContainer = "local";
            testCache = "localTestCache";
            client.addCacheContainer("local", testCache);
            client.addConfigurations("local");
            client.addSocketBinding("hotrod-local", "clustered-sockets", 11223);
            client.addLocalCache(testCache, "local", "localCacheConfiguration");
            client.addHotRodEndpoint("hotrodLocal", "local", testCache, "hotrod-local");
        } else {
            testCache = "replTestCache";
            client.addReplicatedCache(testCache, "clustered", "replicated");
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        ManagementClient client = ManagementClient.getInstance();
        if (ITestUtils.isDistributedMode()) {
            client.removeDistributedCache(testCache, "clustered");
            client.removeDistributedCacheConfiguration("distCacheConfiguration", "clustered");
        } else if (ITestUtils.isLocalMode()) {
            String targetContainer = "local";
            client.removeHotRodEndpoint("hotrodLocal");
            client.removeLocalCache(testCache, "local");
            client.removeDistributedCacheConfiguration("localCacheConfiguration", "local");
            client.removeSocketBinding("hotrod-local", "clustered-sockets");
            client.removeConfigurations("local");
            client.removeCacheContainer("local");
        } else {
            client.removeReplicatedCache(testCache, "clustered");
        }
        client.disableJmx();
    }

    @Override
    protected List<RemoteInfinispanServer> getServers() {
        ArrayList<RemoteInfinispanServer> servers = new ArrayList<RemoteInfinispanServer>();
        servers.add(this.server1);
        if (!ITestUtils.isLocalMode()) {
            servers.add(this.server2);
        }
        return Collections.unmodifiableList(servers);
    }
}

