/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCounterManagerFactory;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.SyncStrongCounter;
import org.infinispan.counter.api.SyncWeakCounter;
import org.infinispan.server.test.category.HotRodClustered;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={HotRodClustered.class})
public class HotRodCounterIT {
    @InfinispanResource(value="container1")
    RemoteInfinispanServer server1;
    private RemoteCacheManager remoteCacheManager;

    @Before
    public void initialize() {
        if (this.remoteCacheManager == null) {
            this.remoteCacheManager = new RemoteCacheManager(this.createRemoteCacheManagerConfiguration(), true);
        }
    }

    @Test
    public void testCounters() {
        CounterManager counterManager = RemoteCounterManagerFactory.asCounterManager((RemoteCacheManager)this.remoteCacheManager);
        counterManager.defineCounter("c1", CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).upperBound(10L).initialValue(1L).build());
        counterManager.defineCounter("c2", CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(5L).build());
        SyncStrongCounter c1 = counterManager.getStrongCounter("c1").sync();
        SyncWeakCounter c2 = counterManager.getWeakCounter("c2").sync();
        Assert.assertEquals((long)1L, (long)c1.getValue());
        Assert.assertEquals((long)5L, (long)c2.getValue());
    }

    private Configuration createRemoteCacheManagerConfiguration() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.addServer().host(this.server1.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server1.getHotrodEndpoint().getPort());
        return config.build();
    }
}

