/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.ServerStatistics;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.server.test.client.hotrod.CustomEvent;
import org.infinispan.server.test.client.hotrod.CustomEventLogListener;
import org.infinispan.server.test.client.hotrod.CustomPojoEventConverterFactory;
import org.infinispan.server.test.client.hotrod.CustomPojoEventFilterFactory;
import org.infinispan.server.test.client.hotrod.CustomPojoFilterConverterFactory;
import org.infinispan.server.test.client.hotrod.DynamicCacheEventConverterFactory;
import org.infinispan.server.test.client.hotrod.DynamicCacheEventFilterFactory;
import org.infinispan.server.test.client.hotrod.EventLogListener;
import org.infinispan.server.test.client.hotrod.FilterConverterFactory;
import org.infinispan.server.test.client.hotrod.SampleEntity;
import org.infinispan.server.test.client.hotrod.StaticCacheEventConverterFactory;
import org.infinispan.server.test.client.hotrod.StaticCacheEventFilterFactory;
import org.infinispan.server.test.client.hotrod.Summary;
import org.infinispan.server.test.client.hotrod.TestKeyValueFilterConverterFactory;
import org.infinispan.server.test.util.ITestUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractRemoteCacheIT {
    private static final Log log = LogFactory.getLog(AbstractRemoteCacheIT.class);
    protected static String testCache = "default";
    protected static RemoteCacheManager remoteCacheManager = null;
    protected RemoteCache remoteCache;
    protected final int ASYNC_OPS_ENTRY_LOAD = 10;

    protected abstract List<RemoteInfinispanServer> getServers();

    @Before
    public void initialize() {
        if (remoteCacheManager == null) {
            Configuration config = this.createRemoteCacheManagerConfiguration(new int[0]);
            remoteCacheManager = new RemoteCacheManager(config, true);
        }
        this.remoteCache = remoteCacheManager.getCache(testCache);
        this.remoteCache.clear();
    }

    @AfterClass
    public static void release() {
        if (remoteCacheManager != null) {
            remoteCacheManager.stop();
            remoteCacheManager = null;
        }
    }

    protected static Archive<?> createPojoArchive() {
        return ((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"pojo.jar")).addClasses(new Class[]{Person.class, Id.class});
    }

    protected static Archive<?> createFilterArchive() {
        return ((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"filter.jar")).addClasses(new Class[]{StaticCacheEventFilterFactory.class, DynamicCacheEventFilterFactory.class, CustomPojoEventFilterFactory.class})).addAsServiceProvider(CacheEventFilterFactory.class, new Class[]{StaticCacheEventFilterFactory.class, DynamicCacheEventFilterFactory.class, CustomPojoEventFilterFactory.class})).add((Asset)new StringAsset("Dependencies: deployment.pojo.jar"), "META-INF/MANIFEST.MF");
    }

    protected static Archive<?> createConverterArchive() {
        return ((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"converter.jar")).addClasses(new Class[]{StaticCacheEventConverterFactory.class, DynamicCacheEventConverterFactory.class, CustomPojoEventConverterFactory.class, CustomEvent.class})).addAsServiceProvider(CacheEventConverterFactory.class, new Class[]{StaticCacheEventConverterFactory.class, DynamicCacheEventConverterFactory.class, CustomPojoEventConverterFactory.class})).add((Asset)new StringAsset("Dependencies: deployment.pojo.jar"), "META-INF/MANIFEST.MF");
    }

    protected static Archive<?> createFilterConverterArchive() {
        return ((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"filter-converter.jar")).addClasses(new Class[]{FilterConverterFactory.class, CustomEvent.class, CustomPojoFilterConverterFactory.class})).addAsServiceProvider(CacheEventFilterConverterFactory.class, new Class[]{FilterConverterFactory.class, CustomPojoFilterConverterFactory.class})).add((Asset)new StringAsset("Dependencies: deployment.pojo.jar"), "META-INF/MANIFEST.MF");
    }

    protected static Archive<?> createKeyValueFilterConverterArchive() {
        return ((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"key-value-filter-converter.jar")).addClasses(new Class[]{TestKeyValueFilterConverterFactory.class, SampleEntity.class, Summary.class, SampleEntity.SampleEntityExternalizer.class, Summary.SummaryExternalizer.class})).addAsServiceProvider(KeyValueFilterConverterFactory.class, new Class[]{TestKeyValueFilterConverterFactory.class})).add((Asset)new StringAsset("Dependencies: deployment.pojo.jar"), "META-INF/MANIFEST.MF");
    }

    private Configuration createRemoteCacheManagerConfiguration(int ... hotrodPortOverrides) {
        if (hotrodPortOverrides.length != 0) assert (this.getServers().size() == hotrodPortOverrides.length) : "The number of defined ports is different from server count";
        ConfigurationBuilder config = new ConfigurationBuilder();
        int index = 0;
        for (RemoteInfinispanServer server : this.getServers()) {
            int port = hotrodPortOverrides.length != 0 ? hotrodPortOverrides[index] : server.getHotrodEndpoint().getPort();
            config.addServer().host(server.getHotrodEndpoint().getInetAddress().getHostName()).port(port);
            ++index;
        }
        config.balancingStrategy("org.infinispan.server.test.client.hotrod.HotRodTestRequestBalancingStrategy").balancingStrategy("org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy").forceReturnValues(false).tcpNoDelay(true).transportFactory("org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory").marshaller((Marshaller)new GenericJBossMarshaller(Thread.currentThread().getContextClassLoader())).asyncExecutorFactory().factoryClass("org.infinispan.client.hotrod.impl.async.DefaultAsyncExecutorFactory").addExecutorProperty("infinispan.client.hotrod.default_executor_factory.pool_size", "10").addExecutorProperty("infinispan.client.hotrod.default_executor_factory.queue_size", "100000").keySizeEstimate(64).valueSizeEstimate(512);
        return config.build();
    }

    private long numEntriesOnServer(int serverIndex) {
        return this.getServers().get(serverIndex).getCacheManager(this.getCacheManagerName()).getCache(testCache).getNumberOfEntries();
    }

    protected String getCacheManagerName() {
        return "clustered";
    }

    @Test
    public void testReplaceWithVersionWithLifespan() throws Exception {
        int lifespanInSecs = 1;
        Assert.assertNull((Object)this.remoteCache.replace((Object)"aKey", (Object)"aValue"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertTrue((boolean)this.remoteCache.replaceWithVersion((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion(), lifespanInSecs));
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertNotEquals((long)entry2.getVersion(), (long)valueBinary.getVersion());
        Assert.assertEquals((Object)"aNewValue", (Object)entry2.getValue());
        ITestUtils.sleepForSecs(lifespanInSecs + 1);
        Assert.assertNull((Object)this.remoteCache.getVersioned((Object)"aKey"));
    }

    @Test
    public void testReplaceOldValue() throws Exception {
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        MetadataValue previous = this.remoteCache.getWithMetadata((Object)"aKey");
        Assert.assertTrue((boolean)this.remoteCache.replace((Object)"aKey", (Object)"aValue", (Object)"aNewValue"));
        MetadataValue entry2 = this.remoteCache.getWithMetadata((Object)"aKey");
        Assert.assertNotEquals((long)entry2.getVersion(), (long)previous.getVersion());
        Assert.assertEquals((Object)"aNewValue", (Object)entry2.getValue());
    }

    @Test
    public void testReplaceOldValueWithLifespan() throws Exception {
        int lifespanInMillis = 10;
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        MetadataValue previous = this.remoteCache.getWithMetadata((Object)"aKey");
        Assert.assertTrue((boolean)this.remoteCache.replace((Object)"aKey", (Object)"aValue", (Object)"aNewValue", (long)lifespanInMillis, TimeUnit.MILLISECONDS));
        MetadataValue entry2 = this.remoteCache.getWithMetadata((Object)"aKey");
        Assert.assertNotEquals((long)entry2.getVersion(), (long)previous.getVersion());
        Assert.assertEquals((Object)"aNewValue", (Object)entry2.getValue());
        Thread.sleep(2 * lifespanInMillis);
        Assert.assertNull((Object)this.remoteCache.getWithMetadata((Object)"aKey"));
    }

    @Test
    public void testReplaceOldValueWithLifespanAndExpiration() throws Exception {
        int lifespanInMillis = 10;
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        MetadataValue previous = this.remoteCache.getWithMetadata((Object)"aKey");
        Assert.assertTrue((boolean)this.remoteCache.replace((Object)"aKey", (Object)"aValue", (Object)"aNewValue", (long)lifespanInMillis, TimeUnit.MINUTES, (long)lifespanInMillis, TimeUnit.MILLISECONDS));
        MetadataValue entry2 = this.remoteCache.getWithMetadata((Object)"aKey");
        Assert.assertNotEquals((long)entry2.getVersion(), (long)previous.getVersion());
        Assert.assertEquals((Object)"aNewValue", (Object)entry2.getValue());
        Thread.sleep(2 * lifespanInMillis);
        Assert.assertNull((Object)this.remoteCache.getWithMetadata((Object)"aKey"));
    }

    @Test
    public void testPut() throws Exception {
        Assert.assertNull((Object)this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        Assert.assertTrue((boolean)this.remoteCache.containsKey((Object)"aKey"));
        Assert.assertEquals((Object)this.remoteCache.get((Object)"aKey"), (Object)"aValue");
    }

    @Test
    public void testPutWithLifespan() {
        long lifespanInSecs = 1L;
        this.remoteCache.put((Object)"lkey", (Object)"value", lifespanInSecs, TimeUnit.SECONDS);
        ITestUtils.sleepForSecs(lifespanInSecs + 1L);
        Assert.assertNull((Object)this.remoteCache.get((Object)"lkey"));
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)0L, (long)this.remoteCache.size());
        Assert.assertNull((Object)this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        Assert.assertTrue((boolean)this.remoteCache.containsKey((Object)"aKey"));
        Assert.assertEquals((long)this.remoteCache.size(), (long)1L);
        Assert.assertEquals((long)this.remoteCache.size(), (long)1L);
        Assert.assertNull((Object)this.remoteCache.put((Object)"anotherKey", (Object)"anotherValue"));
        Assert.assertTrue((boolean)this.remoteCache.containsKey((Object)"anotherKey"));
        Assert.assertEquals((long)this.remoteCache.size(), (long)2L);
        Assert.assertNull((Object)this.remoteCache.remove((Object)"anotherKey"));
        Assert.assertTrue((!this.remoteCache.containsKey((Object)"anotherKey") ? 1 : 0) != 0);
        Assert.assertEquals((long)this.remoteCache.size(), (long)1L);
        Assert.assertNull((Object)this.remoteCache.remove((Object)"aKey"));
        Assert.assertTrue((!this.remoteCache.containsKey((Object)"aKey") ? 1 : 0) != 0);
        Assert.assertEquals((long)this.remoteCache.size(), (long)0L);
    }

    @Test
    public void testIsEmpty() throws IOException {
        Assert.assertTrue((boolean)this.remoteCache.isEmpty());
        Assert.assertNull((Object)this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        Assert.assertTrue((boolean)this.remoteCache.containsKey((Object)"aKey"));
        Assert.assertTrue((!this.remoteCache.isEmpty() ? 1 : 0) != 0);
        Assert.assertNull((Object)this.remoteCache.remove((Object)"aKey"));
        Assert.assertTrue((!this.remoteCache.containsKey((Object)"aKey") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.remoteCache.isEmpty());
    }

    @Test
    public void testContains() {
        Assert.assertTrue((!this.remoteCache.containsKey((Object)"aKey") ? 1 : 0) != 0);
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        Assert.assertTrue((boolean)this.remoteCache.containsKey((Object)"aKey"));
    }

    @Test
    public void testContainsValue() {
        Assert.assertTrue((!this.remoteCache.containsValue((Object)"aValue") ? 1 : 0) != 0);
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        Assert.assertTrue((boolean)this.remoteCache.containsValue((Object)"aValue"));
    }

    @Test
    public void testWithFlags() throws IOException {
        Assert.assertNull((Object)this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        Assert.assertTrue((boolean)this.remoteCache.containsKey((Object)"aKey"));
        Assert.assertEquals((Object)"aValue", (Object)this.remoteCache.get((Object)"aKey"));
        Assert.assertNull((Object)this.remoteCache.put((Object)"aKey", (Object)"anotherValue"));
        Assert.assertEquals((Object)"anotherValue", (Object)this.remoteCache.get((Object)"aKey"));
        Assert.assertEquals((Object)"anotherValue", (Object)this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"aKey", (Object)"yetAnotherValue"));
    }

    @Test
    public void testBulkOperations() {
        HashMap<String, String> mapOut = new HashMap<String, String>();
        mapOut.put("aKey", "aValue");
        mapOut.put("bKey", "bValue");
        mapOut.put("cKey", "cValue");
        this.remoteCache.putAll(mapOut);
        Map mapIn = this.remoteCache.getBulk();
        Assert.assertEquals((Object)mapIn, mapOut);
    }

    @Test
    public void testBulkOperationsWithLifespan() {
        long lifespanInSecs = 1L;
        Map mapIn = new HashMap();
        HashMap<String, String> mapOut = new HashMap<String, String>();
        mapOut.put("aKey", "aValue");
        mapOut.put("bKey", "bValue");
        mapOut.put("cKey", "cValue");
        this.remoteCache.putAll(mapOut, lifespanInSecs, TimeUnit.SECONDS);
        ITestUtils.sleepForSecs(lifespanInSecs + 1L);
        mapIn = this.remoteCache.getBulk();
        Assert.assertEquals((long)mapIn.size(), (long)0L);
    }

    @Test
    public void testGetBulkWithLimit() {
        HashMap<String, String> mapOut = new HashMap<String, String>();
        mapOut.put("aKey", "aValue");
        mapOut.put("bKey", "bValue");
        mapOut.put("cKey", "cValue");
        this.remoteCache.putAll(mapOut);
        Map mapIn = this.remoteCache.getBulk(2);
        Assert.assertEquals((long)mapIn.size(), (long)2L);
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)testCache, (Object)this.remoteCache.getName());
    }

    @Test
    public void testKeySet() {
        this.remoteCache.put((Object)"k1", (Object)"v1");
        this.remoteCache.put((Object)"k2", (Object)"v2");
        this.remoteCache.put((Object)"k3", (Object)"v3");
        HashSet<String> expectedKeySet = new HashSet<String>();
        expectedKeySet.add("k1");
        expectedKeySet.add("k2");
        expectedKeySet.add("k3");
        Assert.assertEquals(expectedKeySet, (Object)this.remoteCache.keySet());
    }

    @Test
    public void testEntrySet() {
        this.remoteCache.put((Object)"k1", (Object)"v1");
        this.remoteCache.put((Object)"k2", (Object)"v2");
        this.remoteCache.put((Object)"k3", (Object)"v3");
        HashSet<AbstractMap.SimpleEntry<String, String>> expectedEntrySet = new HashSet<AbstractMap.SimpleEntry<String, String>>();
        expectedEntrySet.add(new AbstractMap.SimpleEntry<String, String>("k1", "v1"));
        expectedEntrySet.add(new AbstractMap.SimpleEntry<String, String>("k2", "v2"));
        expectedEntrySet.add(new AbstractMap.SimpleEntry<String, String>("k3", "v3"));
        Assert.assertEquals(expectedEntrySet, (Object)this.remoteCache.entrySet());
    }

    @Test
    public void testValues() {
        this.remoteCache.put((Object)"k1", (Object)"v1");
        this.remoteCache.put((Object)"k2", (Object)"v2");
        this.remoteCache.put((Object)"k3", (Object)"v3");
        List values = this.remoteCache.values().stream().collect(Collectors.toList());
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("v1"));
        Assert.assertTrue((boolean)values.contains("v2"));
        Assert.assertTrue((boolean)values.contains("v3"));
    }

    @Test
    public void testGetWithMetadata() {
        this.remoteCache.put((Object)"k1", (Object)"v1", 10000000L, TimeUnit.MICROSECONDS);
        this.remoteCache.put((Object)"k2", (Object)"v2", 10L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS);
        MetadataValue k1 = this.remoteCache.getWithMetadata((Object)"k1");
        MetadataValue k2 = this.remoteCache.getWithMetadata((Object)"k2");
        Assert.assertEquals((Object)k1.getValue(), (Object)"v1");
        Assert.assertEquals((long)k1.getLifespan(), (long)10L);
        Assert.assertEquals((long)k1.getMaxIdle(), (long)-1L);
        Assert.assertEquals((Object)k2.getValue(), (Object)"v2");
        Assert.assertEquals((long)k2.getLifespan(), (long)10L);
        Assert.assertEquals((long)k2.getMaxIdle(), (long)10L);
    }

    @Test
    public void testRemoveAsync() throws Exception {
        for (int i = 0; i <= 10; ++i) {
            this.remoteCache.put((Object)("key" + i), (Object)("value" + i));
        }
        HashSet<CompletableFuture> futures = new HashSet<CompletableFuture>();
        for (int i = 0; i <= 10; ++i) {
            futures.add(this.remoteCache.removeAsync((Object)("key" + i)));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)0L, (long)this.numEntriesOnServer(0));
    }

    @Test
    public void testReplaceAsync() throws Exception {
        this.remoteCache.clear();
        for (int i = 0; i <= 10; ++i) {
            this.remoteCache.put((Object)("key" + i), (Object)("value" + i));
        }
        HashSet<CompletableFuture> futures = new HashSet<CompletableFuture>();
        for (int i = 0; i <= 10; ++i) {
            futures.add(this.remoteCache.replaceAsync((Object)("key" + i), (Object)("newValue" + i), -1L, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS));
        }
        for (Future future : futures) {
            future.get();
        }
        for (int i = 0; i <= 10; ++i) {
            Assert.assertEquals((Object)("newValue" + i), (Object)this.remoteCache.get((Object)("key" + i)));
        }
    }

    @Test
    public void testGetVersionedCacheEntry() {
        VersionedValue value = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertNull((String)("expected null but received: " + value), (Object)this.remoteCache.getVersioned((Object)"aKey"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        Assert.assertEquals((Object)"aValue", (Object)this.remoteCache.get((Object)"aKey"));
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertNotNull((Object)valueBinary);
        Assert.assertEquals((Object)valueBinary.getValue(), (Object)"aValue");
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertEquals((Object)entry2.getValue(), (Object)"aValue");
        Assert.assertNotEquals((long)entry2.getVersion(), (long)valueBinary.getVersion());
        Assert.assertNotEquals((Object)valueBinary, (Object)entry2);
        this.remoteCache.put((Object)"aKey", (Object)"anotherValue");
        VersionedValue entry3 = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertEquals((Object)entry3.getValue(), (Object)"anotherValue");
        Assert.assertNotEquals((long)entry3.getVersion(), (long)entry2.getVersion());
        Assert.assertNotEquals((Object)entry3, (Object)entry2);
    }

    @Test
    public void testReplace() {
        Assert.assertNull((Object)this.remoteCache.replace((Object)"aKey", (Object)"anotherValue"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        Assert.assertNull((Object)this.remoteCache.replace((Object)"aKey", (Object)"anotherValue"));
        Assert.assertEquals((Object)this.remoteCache.get((Object)"aKey"), (Object)"anotherValue");
    }

    @Test
    public void testReplaceWithVersion() {
        Assert.assertNull((Object)this.remoteCache.replace((Object)"aKey", (Object)"aValue"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertTrue((boolean)this.remoteCache.replaceWithVersion((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion()));
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertNotEquals((long)entry2.getVersion(), (long)valueBinary.getVersion());
        Assert.assertEquals((Object)entry2.getValue(), (Object)"aNewValue");
        Assert.assertTrue((!this.remoteCache.replaceWithVersion((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion()) ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() throws IOException {
        Assert.assertNull((Object)this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        Assert.assertEquals((Object)this.remoteCache.get((Object)"aKey"), (Object)"aValue");
        Assert.assertNull((Object)this.remoteCache.remove((Object)"aKey"));
        Assert.assertTrue((!this.remoteCache.containsKey((Object)"aKey") ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveConditional() throws IOException {
        Assert.assertNull((Object)this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        Assert.assertEquals((Object)this.remoteCache.get((Object)"aKey"), (Object)"aValue");
        Assert.assertFalse((boolean)this.remoteCache.remove((Object)"aKey", (Object)"aValue2"));
        Assert.assertTrue((boolean)this.remoteCache.containsKey((Object)"aKey"));
        Assert.assertTrue((boolean)this.remoteCache.remove((Object)"aKey", (Object)"aValue"));
        Assert.assertFalse((boolean)this.remoteCache.containsKey((Object)"aKey"));
    }

    @Test
    public void testRemoveWithVersion() {
        Assert.assertTrue((!this.remoteCache.removeWithVersion((Object)"aKey", 12321212L) ? 1 : 0) != 0);
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertTrue((boolean)this.remoteCache.removeWithVersion((Object)"aKey", valueBinary.getVersion()));
        this.remoteCache.put((Object)"aKey", (Object)"aNewValue");
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertNotEquals((long)entry2.getVersion(), (long)valueBinary.getVersion());
        Assert.assertEquals((Object)entry2.getValue(), (Object)"aNewValue");
        Assert.assertTrue((!this.remoteCache.removeWithVersion((Object)"aKey", valueBinary.getVersion()) ? 1 : 0) != 0);
    }

    @Test
    public void testPutIfAbsent() {
        this.remoteCache.putIfAbsent((Object)"aKey", (Object)"aValue");
        Assert.assertEquals((long)this.remoteCache.size(), (long)1L);
        Assert.assertEquals((Object)this.remoteCache.get((Object)"aKey"), (Object)"aValue");
        Assert.assertNull((Object)this.remoteCache.putIfAbsent((Object)"aKey", (Object)"anotherValue"));
        Assert.assertEquals((Object)this.remoteCache.get((Object)"aKey"), (Object)"aValue");
    }

    @Test
    public void testPutIfAbsentWithLifespan() throws Exception {
        int lifespanInSecs = 1;
        this.remoteCache.putIfAbsent((Object)"aKey", (Object)"aValue", (long)lifespanInSecs, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)this.remoteCache.size());
        Assert.assertEquals((Object)"aValue", (Object)this.remoteCache.get((Object)"aKey"));
        ITestUtils.sleepForSecs(lifespanInSecs + 1);
        Assert.assertEquals(null, (Object)this.remoteCache.get((Object)"akey"));
        this.remoteCache.putIfAbsent((Object)"aKey", (Object)"aValue");
        Assert.assertEquals((long)1L, (long)this.remoteCache.size());
        Assert.assertEquals((Object)"aValue", (Object)this.remoteCache.get((Object)"aKey"));
        Assert.assertEquals(null, (Object)this.remoteCache.putIfAbsent((Object)"aKey", (Object)"anotherValue", (long)lifespanInSecs, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS));
        ITestUtils.sleepForSecs(lifespanInSecs + 1);
        Assert.assertEquals((Object)"aValue", (Object)this.remoteCache.get((Object)"aKey"));
    }

    @Test
    public void testClear() {
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        this.remoteCache.put((Object)"aKey2", (Object)"aValue");
        this.remoteCache.clear();
        Assert.assertTrue((!this.remoteCache.containsKey((Object)"aKey") ? 1 : 0) != 0);
        Assert.assertTrue((!this.remoteCache.containsKey((Object)"aKey2") ? 1 : 0) != 0);
    }

    @Test
    public void testGetRemoteCacheManager() {
        RemoteCacheManager manager = null;
        manager = this.remoteCache.getRemoteCacheManager();
        Assert.assertEquals((String)"getRemoteCachemanager() returned incorrect value", (Object)manager, (Object)remoteCacheManager);
    }

    @Test
    public void testStats() {
        ServerStatistics remoteStats = this.remoteCache.stats();
        Assert.assertNotNull((Object)remoteStats);
        log.tracef("named stats = %s", (Object)remoteStats.getStatsMap());
    }

    @Test
    public void testUnsupportedOperations() {
        try {
            this.remoteCache.removeAsync((Object)"aKey", (Object)"aValue");
            Assert.fail((String)"call to removeAsync() did not raise UnsupportedOperationException ");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.remoteCache.replaceAsync((Object)"aKey", (Object)"oldValue", (Object)"newValue");
            Assert.fail((String)"call to replaceAsync() did not raise UnsupportedOperationException ");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.remoteCache.replaceAsync((Object)"aKey", (Object)"oldValue", (Object)"newValue", -1L, TimeUnit.SECONDS);
            Assert.fail((String)"call to replaceAsync() did not raise UnsupportedOperationException ");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.remoteCache.replaceAsync((Object)"aKey", (Object)"oldValue", (Object)"newValue", -1L, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS);
            Assert.fail((String)"call to replaceAsync() did not raise UnsupportedOperationException ");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testClearAsync() throws Exception {
        this.fill(this.remoteCache, 10);
        Assert.assertEquals((long)10L, (long)this.numEntriesOnServer(0));
        CompletableFuture future = this.remoteCache.clearAsync();
        future.get();
        Assert.assertEquals((long)0L, (long)this.numEntriesOnServer(0));
    }

    @Test
    public void testPutAsync() throws Exception {
        Assert.assertNull((Object)this.remoteCache.get((Object)"k"));
        CompletableFuture f = this.remoteCache.putAsync((Object)"k", (Object)"v");
        Assert.assertFalse((boolean)f.isCancelled());
        Assert.assertNull(f.get());
        Assert.assertTrue((boolean)f.isDone());
        Assert.assertEquals((Object)"v", (Object)this.remoteCache.get((Object)"k"));
    }

    @Test
    public void testPutWithLifespanAsync() throws Exception {
        long lifespanInSecs = 2L;
        HashSet<CompletableFuture> futures = new HashSet<CompletableFuture>();
        for (int i = 0; i != 10; ++i) {
            futures.add(this.remoteCache.putAsync((Object)("key" + i), (Object)("value" + i), lifespanInSecs, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)10L, (long)this.numEntriesOnServer(0));
        ITestUtils.sleepForSecs(lifespanInSecs + 1L);
        for (int i = 0; i != 10; ++i) {
            Assert.assertEquals(null, (Object)this.remoteCache.get((Object)("key" + i)));
        }
    }

    @Test
    public void testPutIfAbsentAsync() throws Exception {
        HashSet<CompletableFuture> futures = new HashSet<CompletableFuture>();
        for (int i = 0; i != 10; ++i) {
            futures.add(this.remoteCache.putIfAbsentAsync((Object)("key" + i), (Object)("value" + i)));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)10L, (long)this.numEntriesOnServer(0));
        Assert.assertEquals((Object)"value9", (Object)this.remoteCache.get((Object)"key9"));
        for (int i = 0; i != 10; ++i) {
            futures.add(this.remoteCache.putIfAbsentAsync((Object)("key" + i), (Object)("newValue" + i)));
        }
        for (Future future : futures) {
            future.get();
        }
        for (int i = 0; i != 10; ++i) {
            Assert.assertEquals((Object)("value" + i), (Object)this.remoteCache.get((Object)("key" + i)));
        }
    }

    @Test
    public void testPutIfAbsentWithLifespanAsync() throws Exception {
        long lifespanInSecs = 2L;
        HashSet<CompletableFuture> futures = new HashSet<CompletableFuture>();
        for (int i = 0; i != 10; ++i) {
            futures.add(this.remoteCache.putIfAbsentAsync((Object)("key" + i), (Object)("value" + i), lifespanInSecs, TimeUnit.SECONDS));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)10L, (long)this.numEntriesOnServer(0));
        Assert.assertEquals((Object)"value9", (Object)this.remoteCache.get((Object)"key9"));
        ITestUtils.sleepForSecs(lifespanInSecs + 1L);
        for (int i = 0; i != 10; ++i) {
            Assert.assertEquals(null, (Object)this.remoteCache.get((Object)("key" + i)));
        }
    }

    @Test
    public void testReplaceWithVersionWithLifespanAsync() throws Exception {
        int lifespanInSecs = 2;
        Assert.assertNull((Object)this.remoteCache.replace((Object)"aKey", (Object)"aValue"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        CompletableFuture future = this.remoteCache.replaceWithVersionAsync((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion(), lifespanInSecs);
        Assert.assertTrue((boolean)((Boolean)future.get()));
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertNotEquals((long)entry2.getVersion(), (long)valueBinary.getVersion());
        Assert.assertEquals((Object)"aNewValue", (Object)entry2.getValue());
        ITestUtils.sleepForSecs(lifespanInSecs + 1);
        Assert.assertNull((Object)this.remoteCache.getVersioned((Object)"aKey"));
    }

    @Test
    public void testGetAsync() throws Exception {
        this.fill(this.remoteCache, 10);
        Assert.assertEquals((long)10L, (long)this.numEntriesOnServer(0));
        HashSet<CompletableFuture> futures = new HashSet<CompletableFuture>();
        for (int i = 0; i != 10; ++i) {
            futures.add(this.remoteCache.getAsync((Object)("key" + i)));
        }
        for (Future future : futures) {
            Assert.assertNotNull(future.get());
        }
    }

    @Test
    public void testBulkOperationsAsync() throws Exception {
        Map mapIn = new HashMap();
        HashMap mapOut = new HashMap();
        this.fill(mapOut, 10);
        CompletableFuture future = this.remoteCache.putAllAsync(mapOut);
        future.get();
        mapIn = this.remoteCache.getBulk();
        Assert.assertEquals(mapOut, mapIn);
    }

    @Test
    public void testBulkOperationsWithLifespanAsync() throws Exception {
        long lifespanInSecs = 3L;
        Map mapIn = new HashMap();
        HashMap mapOut = new HashMap();
        this.fill(mapOut, 10);
        CompletableFuture future = this.remoteCache.putAllAsync(mapOut, lifespanInSecs, TimeUnit.SECONDS);
        future.get();
        ITestUtils.sleepForSecs(lifespanInSecs + 2L);
        mapIn = this.remoteCache.getBulk();
        Assert.assertEquals((long)0L, (long)mapIn.size());
    }

    @Test
    public void testReplaceWithVersionAsync() throws Exception {
        Assert.assertNull((Object)this.remoteCache.replace((Object)"aKey", (Object)"aValue"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        CompletableFuture future = this.remoteCache.replaceWithVersionAsync((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion());
        Assert.assertTrue((boolean)((Boolean)future.get()));
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertNotEquals((long)entry2.getVersion(), (long)valueBinary.getVersion());
        Assert.assertEquals((Object)"aNewValue", (Object)entry2.getValue());
        future = this.remoteCache.replaceWithVersionAsync((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion());
        Assert.assertFalse((boolean)((Boolean)future.get()));
    }

    @Test
    public void testRemoveWithVersionAsync() throws Exception {
        CompletableFuture future = null;
        future = this.remoteCache.removeWithVersionAsync((Object)"aKey", 12321212L);
        Assert.assertTrue(((Boolean)future.get() == false ? 1 : 0) != 0);
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        VersionedValue valueBinary = this.remoteCache.getVersioned((Object)"aKey");
        future = this.remoteCache.removeWithVersionAsync((Object)"aKey", valueBinary.getVersion());
        Assert.assertTrue((boolean)((Boolean)future.get()));
        this.remoteCache.put((Object)"aKey", (Object)"aNewValue");
        VersionedValue entry2 = this.remoteCache.getVersioned((Object)"aKey");
        Assert.assertNotEquals((long)entry2.getVersion(), (long)valueBinary.getVersion());
        Assert.assertEquals((Object)entry2.getValue(), (Object)"aNewValue");
        future = this.remoteCache.removeWithVersionAsync((Object)"aKey", valueBinary.getVersion());
        Assert.assertTrue(((Boolean)future.get() == false ? 1 : 0) != 0);
    }

    @Test
    public void testGetProtocolVersion() throws Exception {
        Assert.assertEquals((Object)("HotRod client, protocol version: " + ProtocolVersion.DEFAULT_PROTOCOL_VERSION), (Object)this.remoteCache.getProtocolVersion());
    }

    @Test
    public void testPutGetCustomObject() throws Exception {
        Person p = new Person("Martin");
        this.remoteCache.put((Object)"k1", (Object)p);
        Assert.assertEquals((Object)p, (Object)this.remoteCache.get((Object)"k1"));
    }

    @Test
    public void testEventReceiveBasic() {
        EventLogListener eventListener = new EventLogListener();
        this.remoteCache.addClientListener((Object)eventListener);
        try {
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            this.remoteCache.put((Object)1, (Object)"one");
            AbstractRemoteCacheIT.expectOnlyCreatedEvent(1, eventListener);
            this.remoteCache.put((Object)2, (Object)"two");
            AbstractRemoteCacheIT.expectOnlyCreatedEvent(2, eventListener);
            this.remoteCache.put((Object)1, (Object)"newone");
            AbstractRemoteCacheIT.expectOnlyModifiedEvent(1, eventListener);
            this.remoteCache.remove((Object)1);
            AbstractRemoteCacheIT.expectOnlyRemovedEvent(1, eventListener);
        }
        finally {
            this.remoteCache.removeClientListener((Object)eventListener);
        }
    }

    @Test
    public void testEventReceiveConditional() {
        EventLogListener eventListener = new EventLogListener();
        this.remoteCache.addClientListener((Object)eventListener);
        try {
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            this.remoteCache.putIfAbsent((Object)1, (Object)"one");
            AbstractRemoteCacheIT.expectOnlyCreatedEvent(1, eventListener);
            this.remoteCache.putIfAbsent((Object)1, (Object)"again");
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            this.remoteCache.replace((Object)1, (Object)"newone");
            AbstractRemoteCacheIT.expectOnlyModifiedEvent(1, eventListener);
            this.remoteCache.replaceWithVersion((Object)1, (Object)"one", 0L);
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            VersionedValue versioned = this.remoteCache.getVersioned((Object)1);
            this.remoteCache.replaceWithVersion((Object)1, (Object)"one", versioned.getVersion());
            AbstractRemoteCacheIT.expectOnlyModifiedEvent(1, eventListener);
            this.remoteCache.removeWithVersion((Object)1, 0L);
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            versioned = this.remoteCache.getVersioned((Object)1);
            this.remoteCache.removeWithVersion((Object)1, versioned.getVersion());
            AbstractRemoteCacheIT.expectOnlyRemovedEvent(1, eventListener);
        }
        finally {
            this.remoteCache.removeClientListener((Object)eventListener);
        }
    }

    @Test
    public void testEventFilteringStatic() {
        StaticFilteredEventLogListener eventListener = new StaticFilteredEventLogListener();
        this.remoteCache.addClientListener((Object)eventListener);
        try {
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            this.remoteCache.put((Object)1, (Object)"one");
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            this.remoteCache.put((Object)2, (Object)"two");
            AbstractRemoteCacheIT.expectOnlyCreatedEvent(2, eventListener);
            this.remoteCache.remove((Object)1);
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            this.remoteCache.remove((Object)2);
            AbstractRemoteCacheIT.expectOnlyRemovedEvent(2, eventListener);
        }
        finally {
            this.remoteCache.removeClientListener((Object)eventListener);
        }
    }

    @Test
    public void testEventFilteringDynamic() {
        DynamicFilteredEventLogListener eventListener = new DynamicFilteredEventLogListener();
        this.remoteCache.addClientListener((Object)eventListener, new Object[]{3}, null);
        try {
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            this.remoteCache.put((Object)1, (Object)"one");
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            this.remoteCache.put((Object)2, (Object)"two");
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            this.remoteCache.put((Object)3, (Object)"three");
            AbstractRemoteCacheIT.expectOnlyCreatedEvent(3, eventListener);
            this.remoteCache.replace((Object)1, (Object)"new-one");
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            this.remoteCache.replace((Object)2, (Object)"new-two");
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            this.remoteCache.replace((Object)3, (Object)"new-three");
            AbstractRemoteCacheIT.expectOnlyModifiedEvent(3, eventListener);
            this.remoteCache.remove((Object)1);
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            this.remoteCache.remove((Object)2);
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            this.remoteCache.remove((Object)3);
            AbstractRemoteCacheIT.expectOnlyRemovedEvent(3, eventListener);
        }
        finally {
            this.remoteCache.removeClientListener((Object)eventListener);
        }
    }

    @Test
    public void testCustomEvents() {
        StaticCustomEventLogListener eventListener = new StaticCustomEventLogListener();
        this.remoteCache.addClientListener((Object)eventListener);
        try {
            eventListener.expectNoEvents();
            this.remoteCache.put((Object)1, (Object)"one");
            eventListener.expectSingleCustomEvent(1, "one");
            this.remoteCache.put((Object)1, (Object)"newone");
            eventListener.expectSingleCustomEvent(1, "newone");
            this.remoteCache.remove((Object)1);
            eventListener.expectSingleCustomEvent(1, null);
        }
        finally {
            this.remoteCache.removeClientListener((Object)eventListener);
        }
    }

    @Test
    public void testCustomEventsDynamic() {
        DynamicCustomEventLogListener eventListener = new DynamicCustomEventLogListener();
        this.remoteCache.addClientListener((Object)eventListener, null, new Object[]{2});
        try {
            eventListener.expectNoEvents();
            this.remoteCache.put((Object)1, (Object)"one");
            eventListener.expectSingleCustomEvent(1, "one");
            this.remoteCache.put((Object)2, (Object)"two");
            eventListener.expectSingleCustomEvent(2, null);
        }
        finally {
            this.remoteCache.removeClientListener((Object)eventListener);
        }
    }

    @Test
    public void testCustomFilterEvents() {
        FilterCustomEventLogListener eventListener = new FilterCustomEventLogListener();
        this.remoteCache.addClientListener((Object)eventListener, new Object[]{3}, null);
        try {
            eventListener.expectNoEvents();
            this.remoteCache.put((Object)1, (Object)"one");
            eventListener.expectSingleCustomEvent(1, "one");
            this.remoteCache.put((Object)1, (Object)"uno");
            eventListener.expectSingleCustomEvent(1, "uno");
            this.remoteCache.put((Object)2, (Object)"two");
            eventListener.expectSingleCustomEvent(2, "two");
            this.remoteCache.put((Object)2, (Object)"dos");
            eventListener.expectSingleCustomEvent(2, "dos");
            this.remoteCache.put((Object)3, (Object)"three");
            eventListener.expectSingleCustomEvent(3, null);
            this.remoteCache.put((Object)3, (Object)"tres");
            eventListener.expectSingleCustomEvent(3, null);
            this.remoteCache.remove((Object)1);
            eventListener.expectSingleCustomEvent(1, null);
            this.remoteCache.remove((Object)2);
            eventListener.expectSingleCustomEvent(2, null);
            this.remoteCache.remove((Object)3);
            eventListener.expectSingleCustomEvent(3, null);
        }
        finally {
            this.remoteCache.removeClientListener((Object)eventListener);
        }
    }

    @Test
    public void testIterationWithCustomClasses() {
        this.remoteCache.put((Object)"1", (Object)new SampleEntity("value1,value2"));
        this.remoteCache.put((Object)"2", (Object)new SampleEntity("value3,value2"));
        this.remoteCache.put((Object)"ignore", (Object)new SampleEntity("whatever"));
        this.remoteCache.put((Object)"3", (Object)new SampleEntity("value7,value8"));
        final HashMap entryMap = new HashMap();
        try (CloseableIterator closeableIterator = this.remoteCache.retrieveEntries("csv-key-value-filter-converter-factory", null, 10);){
            closeableIterator.forEachRemaining((Consumer)new Consumer<Map.Entry<Object, Object>>(){

                @Override
                public void accept(Map.Entry<Object, Object> e) {
                    entryMap.put(e.getKey(), e.getValue());
                }
            });
        }
        Assert.assertEquals((long)3L, (long)entryMap.size());
        Assert.assertEquals(Arrays.asList("value1", "value2"), ((Summary)entryMap.get("1")).getAttributes());
        Assert.assertEquals(Arrays.asList("value3", "value2"), ((Summary)entryMap.get("2")).getAttributes());
        Assert.assertEquals(Arrays.asList("value7", "value8"), ((Summary)entryMap.get("3")).getAttributes());
    }

    @Test
    public void testEventFilteringCustomPojo() {
        CustomPojoFilteredEventLogListener eventListener = new CustomPojoFilteredEventLogListener();
        this.remoteCache.addClientListener((Object)eventListener, new Object[]{"two"}, null);
        try {
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            this.remoteCache.put((Object)1, (Object)new Person("one"));
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            this.remoteCache.put((Object)2, (Object)new Person("two"));
            AbstractRemoteCacheIT.expectOnlyCreatedEvent(2, eventListener);
            this.remoteCache.remove((Object)1);
            AbstractRemoteCacheIT.expectNoEvents(eventListener);
            this.remoteCache.remove((Object)2);
            AbstractRemoteCacheIT.expectOnlyRemovedEvent(2, eventListener);
        }
        finally {
            this.remoteCache.removeClientListener((Object)eventListener);
        }
    }

    @Test
    public void testCustomEventsCustomPojo() {
        CustomPojoCustomEventLogListener eventListener = new CustomPojoCustomEventLogListener();
        this.remoteCache.addClientListener((Object)eventListener, null, new Object[]{new Person("two")});
        try {
            eventListener.expectNoEvents();
            this.remoteCache.put((Object)1, (Object)new Person("one"));
            eventListener.expectSingleCustomEvent(1, new Person("one"));
            this.remoteCache.put((Object)2, (Object)new Person("two"));
            eventListener.expectSingleCustomEvent(2, null);
        }
        finally {
            this.remoteCache.removeClientListener((Object)eventListener);
        }
    }

    @Test
    public void testCustomFilterEventsCustomPojo() {
        CustomPojoFilterCustomEventLogListener eventListener = new CustomPojoFilterCustomEventLogListener();
        this.remoteCache.addClientListener((Object)eventListener, new Object[]{new Id(3)}, null);
        try {
            eventListener.expectNoEvents();
            this.remoteCache.put((Object)new Id(1), (Object)new Person("one"));
            eventListener.expectSingleCustomEvent(new Id(1), new Person("one"));
            this.remoteCache.put((Object)new Id(1), (Object)new Person("uno"));
            eventListener.expectSingleCustomEvent(new Id(1), new Person("uno"));
            this.remoteCache.put((Object)new Id(2), (Object)new Person("two"));
            eventListener.expectSingleCustomEvent(new Id(2), new Person("two"));
            this.remoteCache.put((Object)new Id(2), (Object)new Person("dos"));
            eventListener.expectSingleCustomEvent(new Id(2), new Person("dos"));
            this.remoteCache.put((Object)new Id(3), (Object)new Person("three"));
            eventListener.expectSingleCustomEvent(new Id(3), null);
            this.remoteCache.put((Object)new Id(3), (Object)new Person("tres"));
            eventListener.expectSingleCustomEvent(new Id(3), null);
            this.remoteCache.remove((Object)new Id(1));
            eventListener.expectSingleCustomEvent(new Id(1), null);
            this.remoteCache.remove((Object)new Id(2));
            eventListener.expectSingleCustomEvent(new Id(2), null);
            this.remoteCache.remove((Object)new Id(3));
            eventListener.expectSingleCustomEvent(new Id(3), null);
        }
        finally {
            this.remoteCache.removeClientListener((Object)eventListener);
        }
    }

    @Test
    public void testDataConversionsWithDefaultRemoteCache() throws Exception {
        String key = "key-byte-array-1";
        byte[] value = new byte[]{72, 101, 108, 108, 111, 33};
        String stringValue = new String(value);
        DataFormat writeValueUnmarshalled = DataFormat.builder().valueType(MediaType.APPLICATION_OCTET_STREAM).build();
        RemoteCache octetStreamCacheValue = this.remoteCache.withDataFormat(writeValueUnmarshalled);
        octetStreamCacheValue.put((Object)key, (Object)value);
        Assert.assertArrayEquals((byte[])value, (byte[])((byte[])octetStreamCacheValue.get((Object)key)));
        Object utfValue = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.TEXT_PLAIN).valueMarshaller((Marshaller)new UTF8StringMarshaller()).build()).get((Object)key);
        Assert.assertEquals((Object)stringValue, (Object)utfValue);
        Object xmlValue = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.APPLICATION_XML).valueMarshaller((Marshaller)new UTF8StringMarshaller()).build()).get((Object)key);
        Assert.assertEquals((Object)("<string>" + stringValue + "</string>"), (Object)xmlValue);
        Object jsonValue = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller((Marshaller)new UTF8StringMarshaller()).build()).get((Object)key);
        Assert.assertEquals((Object)"\"Hello!\"", (Object)jsonValue);
    }

    public static <K> void expectOnlyCreatedEvent(K key, EventLogListener eventListener) {
        AbstractRemoteCacheIT.expectSingleEvent(key, eventListener, ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        AbstractRemoteCacheIT.expectNoEvents(eventListener, ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        AbstractRemoteCacheIT.expectNoEvents(eventListener, ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
    }

    public static <K> void expectOnlyModifiedEvent(K key, EventLogListener eventListener) {
        AbstractRemoteCacheIT.expectSingleEvent(key, eventListener, ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        AbstractRemoteCacheIT.expectNoEvents(eventListener, ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        AbstractRemoteCacheIT.expectNoEvents(eventListener, ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
    }

    public static <K> void expectOnlyRemovedEvent(K key, EventLogListener eventListener) {
        AbstractRemoteCacheIT.expectSingleEvent(key, eventListener, ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
        AbstractRemoteCacheIT.expectNoEvents(eventListener, ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        AbstractRemoteCacheIT.expectNoEvents(eventListener, ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
    }

    public static <K> void expectSingleEvent(K key, EventLogListener eventListener, ClientEvent.Type type) {
        switch (type) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                ClientCacheEntryCreatedEvent createdEvent = (ClientCacheEntryCreatedEvent)eventListener.pollEvent(type);
                Assert.assertEquals(key, (Object)createdEvent.getKey());
                break;
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                ClientCacheEntryModifiedEvent modifiedEvent = (ClientCacheEntryModifiedEvent)eventListener.pollEvent(type);
                Assert.assertEquals(key, (Object)modifiedEvent.getKey());
                break;
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                ClientCacheEntryRemovedEvent removedEvent = (ClientCacheEntryRemovedEvent)eventListener.pollEvent(type);
                Assert.assertEquals(key, (Object)removedEvent.getKey());
            }
        }
        Assert.assertEquals((long)0L, (long)eventListener.queue(type).size());
    }

    public static void expectNoEvents(EventLogListener eventListener) {
        AbstractRemoteCacheIT.expectNoEvents(eventListener, ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        AbstractRemoteCacheIT.expectNoEvents(eventListener, ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        AbstractRemoteCacheIT.expectNoEvents(eventListener, ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
    }

    public static void expectNoEvents(EventLogListener eventListener, ClientEvent.Type type) {
        switch (type) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                Assert.assertEquals((long)0L, (long)eventListener.createdEvents.size());
                break;
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                Assert.assertEquals((long)0L, (long)eventListener.modifiedEvents.size());
                break;
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                Assert.assertEquals((long)0L, (long)eventListener.removedEvents.size());
            }
        }
    }

    protected <T extends Map<String, String>> void fill(T map, int entryCount) {
        for (int i = 0; i != entryCount; ++i) {
            map.put((String)("key" + i), (String)("value" + i));
        }
    }

    public static class Id
    implements Serializable {
        final byte id;

        public Id(int id) {
            this.id = (byte)id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id id1 = (Id)o;
            return this.id == id1.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    public static class Person
    implements Serializable {
        final String name;

        public Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return this.name.equals(person.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    @ClientListener(filterFactoryName="pojo-filter-converter-factory", converterFactoryName="pojo-filter-converter-factory")
    public static class CustomPojoFilterCustomEventLogListener
    extends CustomEventLogListener {
    }

    @ClientListener(converterFactoryName="pojo-converter-factory")
    public static class CustomPojoCustomEventLogListener
    extends CustomEventLogListener {
    }

    @ClientListener(filterFactoryName="pojo-filter-factory")
    public static class CustomPojoFilteredEventLogListener
    extends EventLogListener {
    }

    @ClientListener(filterFactoryName="filter-converter-factory", converterFactoryName="filter-converter-factory")
    public static class FilterCustomEventLogListener
    extends CustomEventLogListener {
    }

    @ClientListener(converterFactoryName="dynamic-converter-factory")
    public static class DynamicCustomEventLogListener
    extends CustomEventLogListener {
    }

    @ClientListener(converterFactoryName="static-converter-factory")
    public static class StaticCustomEventLogListener
    extends CustomEventLogListener {
    }

    @ClientListener(filterFactoryName="dynamic-filter-factory")
    public static class DynamicFilteredEventLogListener
    extends EventLogListener {
    }

    @ClientListener(filterFactoryName="static-filter-factory")
    public static class StaticFilteredEventLogListener
    extends EventLogListener {
    }
}

