/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.licenses;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.infinispan.tools.Dependency;
import org.infinispan.tools.ToolUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LicenseMerger {
    private final DocumentBuilder docBuilder;
    private final Map<String, Document> xmls = new LinkedHashMap<String, Document>();
    private final Document emptyDocument;
    private boolean verbose;

    LicenseMerger() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        this.docBuilder = dbf.newDocumentBuilder();
        this.emptyDocument = this.docBuilder.newDocument();
    }

    private void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private void loadLicenseFromJar(String fileName) throws Exception {
        block14: {
            try (JarFile jar = new JarFile(fileName);){
                JarEntry entry = jar.getJarEntry("META-INF/licenses.xml");
                if (entry != null) {
                    try (InputStream inputStream = jar.getInputStream(entry);){
                        Document doc = this.docBuilder.parse(inputStream);
                        this.xmls.put(ToolUtils.getBaseFileName(fileName), doc);
                        if (this.verbose) {
                            System.out.printf("Loaded license from JAR %s%n", fileName);
                        }
                        break block14;
                    }
                }
                this.xmls.put(ToolUtils.getBaseFileName(fileName), this.emptyDocument);
                if (this.verbose) {
                    System.out.printf("Empty license for JAR %s%n", fileName);
                }
            }
        }
    }

    private void loadLicenseFromXML(String fileName) throws Exception {
        Document doc = this.docBuilder.parse(new File(fileName));
        this.xmls.put(ToolUtils.getBaseFileName(fileName), doc);
        if (this.verbose) {
            System.out.printf("Loaded license from XML %s%n", fileName);
        }
    }

    void loadLicense(String filename) throws Exception {
        if (filename.endsWith(".jar")) {
            this.loadLicenseFromJar(filename);
        } else if (filename.endsWith(".xml")) {
            this.loadLicenseFromXML(filename);
        } else {
            throw new IllegalArgumentException(filename);
        }
    }

    public void write(boolean inclusiveMode, OutputStream os) throws TransformerException {
        if (this.verbose) {
            System.out.printf("Inclusive mode %s%n", inclusiveMode);
        }
        Document aggregated = this.docBuilder.newDocument();
        Element aggregatedDependencies = (Element)aggregated.appendChild(aggregated.createElement("licenseSummary")).appendChild(aggregated.createElement("dependencies"));
        ConcurrentHashMap<String, Node> artifacts = new ConcurrentHashMap<String, Node>();
        for (Map.Entry<String, Document> l : this.xmls.entrySet()) {
            Document doc = l.getValue();
            if (doc == this.emptyDocument) continue;
            for (Dependency dep : ToolUtils.parseXMLDependencies(doc)) {
                if (inclusiveMode && !this.xmls.containsKey(String.format("%s-%s", dep.getArtifact(), dep.getVersion()))) continue;
                artifacts.computeIfAbsent(dep.getId(), a -> aggregated.adoptNode(dep.getNode().cloneNode(true)));
            }
        }
        artifacts.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> aggregatedDependencies.appendChild((Node)entry.getValue()));
        ToolUtils.printDocument(aggregated, os);
    }

    public static void main(String[] argv) throws Exception {
        LicenseMerger licenseMerger = new LicenseMerger();
        File outputFile = new File(System.getProperty("user.dir"), "licenses.xml");
        boolean inclusiveMode = false;
        boolean verbose = false;
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        block17: for (int i = 0; i < argv.length; ++i) {
            switch (argv[i]) {
                case "-v": {
                    verbose = true;
                    licenseMerger.setVerbose(true);
                    continue block17;
                }
                case "-i": {
                    inclusiveMode = true;
                    continue block17;
                }
                case "-o": {
                    outputFile = new File(argv[++i]);
                    continue block17;
                }
                case "-r": {
                    String[] responseData;
                    for (String filename : responseData = new String(Files.readAllBytes(Paths.get(argv[++i], new String[0])), StandardCharsets.UTF_8).split("\\s+")) {
                        licenseMerger.loadLicense(filename);
                    }
                    continue block17;
                }
                default: {
                    files.add(argv[i]);
                }
            }
        }
        outputFile.getParentFile().mkdirs();
        for (String file : files) {
            licenseMerger.loadLicense(file);
        }
        try (FileOutputStream os = new FileOutputStream(outputFile);){
            licenseMerger.write(inclusiveMode, os);
            if (verbose) {
                System.out.printf("Wrote merged licenses to %s%n", outputFile);
            }
        }
        ToolUtils.removeEmptyLinesFromFile(outputFile);
    }
}

