/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.remote;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class ConfigurationPropertiesOverrides {
    public static final String OPERATION_READ_TIMEOUT = "infinispan.spring.operation.read.timeout";
    public static final String OPERATION_WRITE_TIMEOUT = "infinispan.spring.operation.write.timeout";
    private final Properties overridingProperties = new Properties();

    public boolean isEmpty() {
        return this.overridingProperties.isEmpty();
    }

    boolean containsProperty(String key) {
        String prop = this.overridingProperties.getProperty(key);
        return prop != null && !prop.isEmpty();
    }

    @Deprecated
    public void setTransportFactory(String TransportFactory) {
    }

    public void setServerList(Collection<InetSocketAddress> serverList) {
        StringBuilder serverListStr = new StringBuilder();
        for (InetSocketAddress server : serverList) {
            serverListStr.append(server.getHostName()).append(":").append(server.getPort()).append(";");
        }
        serverListStr.deleteCharAt(serverListStr.length() - 1);
        this.overridingProperties.setProperty("infinispan.client.hotrod.server_list", serverListStr.toString());
    }

    public void setMarshaller(String marshaller) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.marshaller", marshaller);
    }

    public void setClassAllowList(String allowListRegex) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.java_serial_allowlist", allowListRegex);
    }

    public void setAsyncExecutorFactory(String asyncExecutorFactory) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.async_executor_factory", asyncExecutorFactory);
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.tcp_no_delay", Boolean.toString(tcpNoDelay));
    }

    public void setTcpKeepAlive(boolean tcpKeepAlive) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.tcp_keep_alive", Boolean.toString(tcpKeepAlive));
    }

    public void setRequestBalancingStrategy(String requestBalancingStrategy) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.request_balancing_strategy", requestBalancingStrategy);
    }

    @Deprecated
    public void setKeySizeEstimate(int keySizeEstimate) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.key_size_estimate", Integer.toString(keySizeEstimate));
    }

    @Deprecated
    public void setValueSizeEstimate(int valueSizeEstimate) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.value_size_estimate", Integer.toString(valueSizeEstimate));
    }

    public void setForceReturnValues(boolean forceReturnValues) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.force_return_values", Boolean.toString(forceReturnValues));
    }

    public void setReadTimeout(long readTimeout) {
        this.overridingProperties.setProperty(OPERATION_READ_TIMEOUT, Long.toString(readTimeout));
    }

    public void setWriteTimeout(long writeTimeout) {
        this.overridingProperties.setProperty(OPERATION_WRITE_TIMEOUT, Long.toString(writeTimeout));
    }

    public void setNearCacheMode(String mode) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.near_cache.mode", mode);
    }

    public void setNearCacheMaxEntries(int maxEntries) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.near_cache.max_entries", Integer.toString(maxEntries));
    }

    public void setNearCacheNamePattern(String pattern) {
        this.overridingProperties.setProperty("infinispan.client.hotrod.near_cache.name_pattern", pattern);
    }

    public Properties override(Properties configurationPropertiesToOverride) {
        Properties answer = (Properties)Properties.class.cast(configurationPropertiesToOverride.clone());
        for (Map.Entry<Object, Object> prop : this.overridingProperties.entrySet()) {
            answer.setProperty((String)String.class.cast(prop.getKey()), (String)String.class.cast(prop.getValue()));
        }
        return answer;
    }
}

