/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit4;

import java.util.Objects;
import net.spy.memcached.MemcachedClient;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.api.RestTestClientDriver;
import org.infinispan.server.test.api.TestClientDriver;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class InfinispanServerTestMethodRule
implements TestRule,
TestClientDriver {
    private final TestClient testClient;

    public InfinispanServerTestMethodRule(InfinispanServerRule infinispanServerRule) {
        Objects.requireNonNull(infinispanServerRule, "InfinispanServerRule class Rule is null");
        this.testClient = new TestClient(infinispanServerRule.getTestServer());
    }

    public String getMethodName() {
        return this.testClient.getMethodName();
    }

    public String getMethodName(String qualifier) {
        return this.testClient.getMethodName(qualifier);
    }

    public HotRodTestClientDriver hotrod() {
        return this.testClient.hotrod();
    }

    public RestTestClientDriver rest() {
        return this.testClient.rest();
    }

    public CounterManager getCounterManager() {
        return this.testClient.getCounterManager();
    }

    public MemcachedClient getMemcachedClient() {
        return this.testClient.getMemcachedClient();
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                InfinispanServerTestMethodRule.this.testClient.initResources();
                try {
                    InfinispanServerTestMethodRule.this.testClient.setMethodName(description.getTestClass().getSimpleName() + "." + description.getMethodName());
                    base.evaluate();
                }
                finally {
                    InfinispanServerTestMethodRule.this.testClient.clearResources();
                }
            }
        };
    }

    public String addScript(RemoteCacheManager remoteCacheManager, String script) {
        return this.testClient.addScript(remoteCacheManager, script);
    }

    public RestClient newRestClient(RestClientConfigurationBuilder restClientConfigurationBuilder) {
        return this.testClient.newRestClient(restClientConfigurationBuilder);
    }
}

