/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.context;

import java.io.Closeable;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.Util;
import org.infinispan.server.context.ServerInitialContextFactory;

public class ServerInitialContextFactoryBuilder
implements InitialContextFactoryBuilder,
Closeable {
    private final ConcurrentMap<String, Object> namedObjects = new ConcurrentHashMap<String, Object>();
    private final Map<String, InitialContextFactory> initialContextFactories = ServiceFinder.load(InitialContextFactory.class, (ClassLoader[])new ClassLoader[]{Thread.currentThread().getContextClassLoader()}).stream().collect(Collectors.toMap(ServerInitialContextFactoryBuilder.className(), Function.identity()));

    @Override
    public InitialContextFactory createInitialContextFactory(Hashtable<?, ?> environment) throws NamingException {
        String className;
        String string = className = environment != null ? (String)environment.get("java.naming.factory.initial") : null;
        if (className == null) {
            return new ServerInitialContextFactory(this.namedObjects);
        }
        if (this.initialContextFactories.containsKey(className)) {
            return this.initialContextFactories.get(className);
        }
        return (InitialContextFactory)InitialContextFactory.class.cast(Util.getInstance((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader()));
    }

    @Override
    public void close() {
        this.namedObjects.values().stream().filter(v -> v instanceof AutoCloseable).forEach(o -> Util.close((AutoCloseable)((AutoCloseable)o)));
    }

    static <T> Function<T, String> className() {
        return t -> t.getClass().getName();
    }
}

