/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.io.File;
import java.util.Properties;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;

public class UserPropertiesConfiguration
extends ConfigurationElement<UserPropertiesConfiguration> {
    static final AttributeDefinition<String> DIGEST_REALM_NAME = AttributeDefinition.builder((Enum)Attribute.DIGEST_REALM_NAME, null, String.class).build();
    static final AttributeDefinition<String> PATH = AttributeDefinition.builder((Enum)Attribute.PATH, (Object)"users.properties", String.class).build();
    static final AttributeDefinition<Boolean> PLAIN_TEXT = AttributeDefinition.builder((Enum)Attribute.PLAIN_TEXT, (Object)false, Boolean.class).build();
    static final AttributeDefinition<String> RELATIVE_TO = AttributeDefinition.builder((Enum)Attribute.RELATIVE_TO, (Object)"infinispan.server.config.path", String.class).autoPersist(false).build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(UserPropertiesConfiguration.class, new AttributeDefinition[]{DIGEST_REALM_NAME, PATH, PLAIN_TEXT, RELATIVE_TO});
    }

    UserPropertiesConfiguration(AttributeSet attributes) {
        super((Enum)Element.USER_PROPERTIES, attributes, new ConfigurationElement[0]);
    }

    public String path() {
        return (String)this.attributes.attribute(PATH).get();
    }

    public String relativeTo() {
        return (String)this.attributes.attribute(RELATIVE_TO).get();
    }

    public boolean plainText() {
        return (Boolean)this.attributes.attribute(PLAIN_TEXT).get();
    }

    public String digestRealmName() {
        return (String)this.attributes.attribute(DIGEST_REALM_NAME).get();
    }

    public File getFile(Properties properties) {
        String path = (String)this.attributes.attribute(PATH).get();
        String relativeTo = properties.getProperty((String)this.attributes.attribute(RELATIVE_TO).get());
        return new File(ParseUtils.resolvePath((String)path, (String)relativeTo));
    }
}

