/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.ietf.jgss.Oid;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.configuration.security.KerberosSecurityFactoryConfiguration;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.wildfly.common.Assert;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.asn1.OidsUtil;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server._private.ElytronMessages;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.mechanism.gssapi.GSSCredentialSecurityFactory;

public class KerberosSecurityFactoryConfigurationBuilder
implements Builder<KerberosSecurityFactoryConfiguration> {
    private final AttributeSet attributes;
    private final RealmConfigurationBuilder realmBuilder;
    private CredentialSource credentialSource;

    KerberosSecurityFactoryConfigurationBuilder(RealmConfigurationBuilder realmBuilder) {
        this.realmBuilder = realmBuilder;
        this.attributes = KerberosSecurityFactoryConfiguration.attributeDefinitionSet();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public KerberosSecurityFactoryConfigurationBuilder principal(String principal) {
        this.attributes.attribute(KerberosSecurityFactoryConfiguration.PRINCIPAL).set((Object)principal);
        return this;
    }

    public KerberosSecurityFactoryConfigurationBuilder keyTabPath(String path) {
        this.attributes.attribute(KerberosSecurityFactoryConfiguration.KEYTAB_PATH).set((Object)path);
        return this;
    }

    public KerberosSecurityFactoryConfigurationBuilder relativeTo(String relativeTo) {
        this.attributes.attribute(KerberosSecurityFactoryConfiguration.RELATIVE_TO).set((Object)relativeTo);
        return this;
    }

    public KerberosSecurityFactoryConfigurationBuilder addOption(String name, String value) {
        ((Map)this.attributes.attribute(KerberosSecurityFactoryConfiguration.OPTIONS).get()).put(name, value);
        return this;
    }

    public KerberosSecurityFactoryConfigurationBuilder failCache(long failCache) {
        this.attributes.attribute(KerberosSecurityFactoryConfiguration.FAIL_CACHE).set((Object)failCache);
        return this;
    }

    public KerberosSecurityFactoryConfigurationBuilder minimumRemainingLifetime(int minimumRemainingLifetime) {
        this.attributes.attribute(KerberosSecurityFactoryConfiguration.MINIMUM_REMAINING_LIFETIME).set((Object)minimumRemainingLifetime);
        return this;
    }

    public KerberosSecurityFactoryConfigurationBuilder requestLifetime(int requestLifetime) {
        this.attributes.attribute(KerberosSecurityFactoryConfiguration.REQUEST_LIFETIME).set((Object)requestLifetime);
        return this;
    }

    public KerberosSecurityFactoryConfigurationBuilder server(boolean server) {
        this.attributes.attribute(KerberosSecurityFactoryConfiguration.SERVER).set((Object)server);
        return this;
    }

    public KerberosSecurityFactoryConfigurationBuilder checkKeyTab(boolean checkKeyTab) {
        this.attributes.attribute(KerberosSecurityFactoryConfiguration.REQUIRED).set((Object)checkKeyTab);
        return this;
    }

    public KerberosSecurityFactoryConfigurationBuilder obtainKerberosTicket(boolean obtainKerberosTicket) {
        this.attributes.attribute(KerberosSecurityFactoryConfiguration.OBTAIN_KERBEROS_TICKET).set((Object)obtainKerberosTicket);
        return this;
    }

    public KerberosSecurityFactoryConfigurationBuilder debug(boolean debug) {
        this.attributes.attribute(KerberosSecurityFactoryConfiguration.DEBUG).set((Object)debug);
        return this;
    }

    public KerberosSecurityFactoryConfigurationBuilder wrapGssCredential(boolean wrapGssCredential) {
        this.attributes.attribute(KerberosSecurityFactoryConfiguration.WRAP_GSS_CREDENTIAL).set((Object)wrapGssCredential);
        return this;
    }

    public KerberosSecurityFactoryConfigurationBuilder addMechanismName(String mechanismName) {
        ((Set)this.attributes.attribute(KerberosSecurityFactoryConfiguration.MECHANISM_NAMES).get()).add(mechanismName);
        return this;
    }

    public KerberosSecurityFactoryConfigurationBuilder addMechanismOid(String mechanismOid) {
        ((Set)this.attributes.attribute(KerberosSecurityFactoryConfiguration.MECHANISM_OIDS).get()).add(mechanismOid);
        return this;
    }

    public KerberosSecurityFactoryConfiguration create() {
        return new KerberosSecurityFactoryConfiguration(this.attributes.protect(), this.credentialSource);
    }

    public KerberosSecurityFactoryConfigurationBuilder read(KerberosSecurityFactoryConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public CredentialSource build(Properties properties) {
        if (this.credentialSource == null) {
            String path = (String)this.attributes.attribute(KerberosSecurityFactoryConfiguration.KEYTAB_PATH).get();
            String relativeTo = properties.getProperty((String)this.attributes.attribute(KerberosSecurityFactoryConfiguration.RELATIVE_TO).get());
            File keyTab = new File(ParseUtils.resolvePath((String)path, (String)relativeTo));
            GSSCredentialSecurityFactory.Builder builder = GSSCredentialSecurityFactory.builder();
            builder.setKeyTab(keyTab).setPrincipal((String)this.attributes.attribute(KerberosSecurityFactoryConfiguration.PRINCIPAL).get()).setCheckKeyTab(((Boolean)this.attributes.attribute(KerberosSecurityFactoryConfiguration.REQUIRED).get()).booleanValue()).setDebug(((Boolean)this.attributes.attribute(KerberosSecurityFactoryConfiguration.DEBUG).get()).booleanValue()).setIsServer(((Boolean)this.attributes.attribute(KerberosSecurityFactoryConfiguration.SERVER).get()).booleanValue()).setObtainKerberosTicket(((Boolean)this.attributes.attribute(KerberosSecurityFactoryConfiguration.OBTAIN_KERBEROS_TICKET).get()).booleanValue()).setWrapGssCredential(((Boolean)this.attributes.attribute(KerberosSecurityFactoryConfiguration.WRAP_GSS_CREDENTIAL).get()).booleanValue()).setOptions((Map)this.attributes.attribute(KerberosSecurityFactoryConfiguration.OPTIONS).get()).setFailCache(((Long)this.attributes.attribute(KerberosSecurityFactoryConfiguration.FAIL_CACHE).get()).longValue()).setRequestLifetime(((Integer)this.attributes.attribute(KerberosSecurityFactoryConfiguration.REQUEST_LIFETIME).get()).intValue()).setMinimumRemainingLifetime(((Integer)this.attributes.attribute(KerberosSecurityFactoryConfiguration.MINIMUM_REMAINING_LIFETIME).get()).intValue());
            try {
                for (String name : (Set)this.attributes.attribute(KerberosSecurityFactoryConfiguration.MECHANISM_NAMES).get()) {
                    String oid = OidsUtil.attributeNameToOid((OidsUtil.Category)OidsUtil.Category.GSS, (String)name);
                    builder.addMechanismOid(new Oid(oid));
                }
                for (String oid : (Set)this.attributes.attribute(KerberosSecurityFactoryConfiguration.MECHANISM_OIDS).get()) {
                    builder.addMechanismOid(new Oid(oid));
                }
                this.credentialSource = this.fromSecurityFactory((SecurityFactory<? extends Credential>)builder.build());
            }
            catch (Exception e) {
                throw new CacheConfigurationException(e);
            }
        }
        return this.credentialSource;
    }

    CredentialSource fromSecurityFactory(final SecurityFactory<? extends Credential> credentialFactory) {
        Assert.checkNotNullParam((String)"credentialFactory", credentialFactory);
        return new CredentialSource(){

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
                return SupportLevel.POSSIBLY_SUPPORTED;
            }

            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
                Credential credential;
                try {
                    credential = (Credential)credentialFactory.create();
                }
                catch (GeneralSecurityException e) {
                    throw ElytronMessages.log.cannotObtainCredentialFromFactory(e);
                }
                return (C)(credential.matches(credentialType, algorithmName, parameterSpec) ? (Credential)credentialType.cast(credential) : null);
            }
        };
    }
}

