/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.router.impl.hotrod.handlers;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.ssl.SslContext;
import io.netty.util.DomainNameMapping;
import io.netty.util.DomainNameMappingBuilder;
import java.util.Optional;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.logging.RouterLogger;
import org.infinispan.server.router.router.impl.hotrod.handlers.SniRouteHandler;
import org.infinispan.server.router.router.impl.hotrod.handlers.util.SslUtils;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.SniRouteSource;

public class SniHandlerInitializer
extends ChannelInitializer<Channel> {
    private final RoutingTable routingTable;

    public SniHandlerInitializer(RoutingTable routingTable) {
        this.routingTable = routingTable;
    }

    protected void initChannel(Channel channel) {
        SslContext defaultContext = SslUtils.INSTANCE.toNettySslContext(Optional.empty());
        DomainNameMappingBuilder domainMappingBuilder = new DomainNameMappingBuilder((Object)defaultContext);
        this.routingTable.streamRoutes(SniRouteSource.class, RouteDestination.class).map(r -> (SniRouteSource)r.getRouteSource()).forEach(r -> domainMappingBuilder.add(r.getSniHostName(), (Object)SslUtils.INSTANCE.toNettySslContext(Optional.of(r.getSslContext()))));
        DomainNameMapping domainNameMapping = domainMappingBuilder.build();
        RouterLogger.SERVER.debugf("Using SNI Handler with domain mapping %s", domainNameMapping);
        channel.pipeline().addLast(new ChannelHandler[]{new SniRouteHandler((DomainNameMapping<? extends SslContext>)domainNameMapping, this.routingTable)});
    }
}

