/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.operation;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.Util;
import org.infinispan.server.resp.response.LCSResponse;

public class LCSOperation {
    public static CompletionStage<LCSResponse> performOperation(AdvancedCache<byte[], byte[]> cache, List<byte[]> arguments, boolean isLcs) {
        LCSOperationContext lcsCtx = new LCSOperationContext(arguments, isLcs);
        lcsCtx.cache = cache;
        return lcsCtx.cache.getAllAsync(Set.of(lcsCtx.key1, lcsCtx.key2)).thenApply(m -> {
            if (m.size() < 2) {
                lcsCtx.result = new LCSResponse();
                lcsCtx.result.lcs = Util.EMPTY_BYTE_ARRAY;
            }
            byte[] v1 = LCSOperation.findValue(m, lcsCtx.key1);
            byte[] v2 = LCSOperation.findValue(m, lcsCtx.key2);
            if (v1 == null || v2 == null) {
                lcsCtx.result = new LCSResponse();
                lcsCtx.result.lcs = Util.EMPTY_BYTE_ARRAY;
            }
            lcsCtx.lcsLength(v1, v2);
            if (!lcsCtx.justLen) {
                lcsCtx.backtrack(v1, v2);
            }
            return lcsCtx.result;
        });
    }

    private static byte[] findValue(Map<byte[], byte[]> values, byte[] key) {
        assert (values.size() == 2);
        for (Map.Entry<byte[], byte[]> entry : values.entrySet()) {
            if (!Arrays.equals(entry.getKey(), key)) continue;
            return entry.getValue();
        }
        return null;
    }

    protected static class LCSOperationContext {
        private final boolean isLcs;
        private final List<byte[]> arguments;
        AdvancedCache<byte[], byte[]> cache;
        private byte[] key1;
        private byte[] key2;
        private boolean justLen;
        private boolean idx;
        private boolean matchLen;
        private long minMatchLen;
        private LCSResponse result;

        public LCSResponse getResult() {
            return this.result;
        }

        public LCSOperationContext(byte[] v1, byte[] v2, boolean onlyLen, boolean idx, boolean matchLen, long minMatchLen) {
            this.arguments = null;
            this.justLen = onlyLen;
            this.idx = idx;
            this.matchLen = matchLen;
            this.minMatchLen = minMatchLen;
            this.result = new LCSResponse();
            this.isLcs = false;
        }

        public LCSOperationContext(List<byte[]> arguments, boolean isLcs) {
            this.arguments = arguments;
            this.key1 = null;
            this.key2 = null;
            this.matchLen = false;
            this.justLen = false;
            this.minMatchLen = 0L;
            this.result = new LCSResponse();
            this.isLcs = isLcs;
            this.parseAndLoadOptions();
        }

        private void parseAndLoadOptions() {
            int offset = 0;
            if (!this.isLcs) {
                if (!new String(this.arguments.get(offset++), StandardCharsets.US_ASCII).equals("LCS")) {
                    throw new IllegalArgumentException("Unknown argument for LCS operation");
                }
                if (!new String(this.arguments.get(offset++), StandardCharsets.US_ASCII).equals("KEYS")) {
                    throw new IllegalArgumentException("Unknown argument for LCS operation");
                }
            }
            this.key1 = this.arguments.get(offset++);
            this.key2 = this.arguments.get(offset++);
            block12: for (int i = offset; i < this.arguments.size(); ++i) {
                byte[] arg = this.arguments.get(i);
                switch (new String(arg, StandardCharsets.US_ASCII)) {
                    case "LEN": {
                        if (this.idx) {
                            throw new IllegalArgumentException("ERR If you want both the length and indexes, please just use IDX.");
                        }
                        this.justLen = true;
                        continue block12;
                    }
                    case "IDX": {
                        if (this.matchLen) {
                            throw new IllegalArgumentException("ERR If you want both the length and indexes, please just use IDX.");
                        }
                        this.idx = true;
                        continue block12;
                    }
                    case "MINMATCHLEN": {
                        if (i + 1 > this.arguments.size()) {
                            throw new IllegalArgumentException("ERR syntax error");
                        }
                        this.minMatchLen = Long.parseLong(new String(this.arguments.get(i + 1), StandardCharsets.US_ASCII));
                        ++i;
                        continue block12;
                    }
                    case "WITHMATCHLEN": {
                        if (this.matchLen) {
                            throw new IllegalArgumentException("ERR If you want both the length and indexes, please just use IDX.");
                        }
                        this.matchLen = this.idx;
                        continue block12;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown argument for LCS operation");
                    }
                }
            }
        }

        public void lcsLength(byte[] a, byte[] b) {
            int m = a.length;
            int n = b.length;
            int[][] C = new int[m + 1][n + 1];
            for (int i = 1; i <= m; ++i) {
                for (int j = 1; j <= n; ++j) {
                    C[i][j] = a[i - 1] == b[j - 1] ? C[i - 1][j - 1] + 1 : Math.max(C[i][j - 1], C[i - 1][j]);
                }
            }
            this.result.C = C;
            this.result.len = C[m][n];
        }

        public void backtrack(byte[] aStr, byte[] bStr) {
            int x = aStr.length;
            int y = bStr.length;
            int i = x;
            int j = y;
            int m = this.result.len - 1;
            boolean matching = false;
            if (this.idx) {
                this.result.idx = new ArrayList();
            } else {
                this.result.lcs = new byte[this.result.len];
            }
            while (i > 0 && j > 0) {
                if (aStr[i - 1] == bStr[j - 1]) {
                    matching = true;
                    if (!this.idx) {
                        this.result.lcs[m--] = aStr[i - 1];
                    }
                    --i;
                    --j;
                    continue;
                }
                if (matching) {
                    matching = false;
                    if ((long)(x - i) >= this.minMatchLen && this.idx) {
                        if (this.matchLen) {
                            this.result.idx.add(new long[]{i, x - 1, j, y - 1, x - i});
                        } else {
                            this.result.idx.add(new long[]{i, x - 1, j, y - 1});
                        }
                    }
                    x = i;
                    y = j;
                }
                if (this.result.C[i][j - 1] >= this.result.C[i - 1][j]) {
                    --y;
                    --j;
                    continue;
                }
                --x;
                --i;
            }
            if (matching && this.idx && (long)(x - i) >= this.minMatchLen) {
                if (this.matchLen) {
                    this.result.idx.add(new long[]{i, x - 1, j, y - 1, x - i});
                } else {
                    this.result.idx.add(new long[]{i, x - 1, j, y - 1});
                }
            }
        }
    }
}

