/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.generic;

import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.multimap.impl.EmbeddedMultimapListCache;
import org.infinispan.multimap.impl.EmbeddedMultimapPairCache;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.SortableBucket;
import org.infinispan.multimap.impl.internal.MultimapObjectWrapper;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.Util;
import org.infinispan.server.resp.commands.LimitArgument;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.serialization.Resp3Response;

public class SORT
extends RespCommand
implements Resp3Command {
    private static final char REPLACEMENT = '*';
    private static final String VALUE_PATTERN = "#";
    private static final String HASH_FIELD = "->";
    private boolean readonly = false;

    public SORT() {
        super(-2, 1, 1, 1);
    }

    public void disableStore() {
        this.readonly = true;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        CompletionStage sortedCollection;
        int pos = 0;
        byte[] key = arguments.get(pos++);
        SortableBucket.SortOptions sortOptions = new SortableBucket.SortOptions();
        byte[] destination = null;
        String pattern = null;
        ArrayList<String> getObjectsPatterns = new ArrayList<String>();
        block9: while (pos < arguments.size()) {
            switch (Arg.valueOf(new String(arguments.get(pos++)).toUpperCase()).ordinal()) {
                case 0: {
                    sortOptions.alpha = true;
                    continue block9;
                }
                case 1: {
                    sortOptions.asc = true;
                    continue block9;
                }
                case 2: {
                    sortOptions.asc = false;
                    continue block9;
                }
                case 4: {
                    if (this.readonly) {
                        RespErrorUtil.syntaxError(handler.allocator());
                        return handler.myStage();
                    }
                    if (pos >= arguments.size()) {
                        RespErrorUtil.syntaxError(handler.allocator());
                        return handler.myStage();
                    }
                    destination = arguments.get(pos++);
                    continue block9;
                }
                case 5: {
                    if (pos >= arguments.size()) {
                        RespErrorUtil.syntaxError(handler.allocator());
                        return handler.myStage();
                    }
                    pattern = new String(arguments.get(pos++));
                    continue block9;
                }
                case 3: {
                    LimitArgument limitArgument = LimitArgument.parse(handler, arguments, pos);
                    if (limitArgument.error) {
                        return handler.myStage();
                    }
                    sortOptions.offset = limitArgument.offset;
                    sortOptions.count = limitArgument.count;
                    pos = limitArgument.nextArgPos;
                    continue block9;
                }
                case 6: {
                    if (pos >= arguments.size()) {
                        RespErrorUtil.syntaxError(handler.allocator());
                        return handler.myStage();
                    }
                    getObjectsPatterns.add(new String(arguments.get(pos++)));
                    continue block9;
                }
            }
            RespErrorUtil.syntaxError(handler.allocator());
            return handler.myStage();
        }
        MediaType vmt = handler.cache().getValueDataConversion().getStorageMediaType();
        AdvancedCache cache = handler.typedCache(vmt);
        if (pattern == null || !pattern.contains("*")) {
            sortOptions.skipSort = pattern != null;
            sortedCollection = cache.getCacheEntryAsync((Object)key).thenApply(e -> {
                if (e == null) {
                    return Collections.emptyList();
                }
                if (!(e.getValue() instanceof SortableBucket)) {
                    throw new ClassCastException();
                }
                SortableBucket sb = (SortableBucket)e.getValue();
                return sb.sort(sortOptions);
            });
        } else {
            String finalPattern = pattern;
            sortedCollection = cache.getCacheEntryAsync((Object)key).thenCompose(entry -> {
                if (entry == null) {
                    return CompletableFuture.completedFuture(Collections.emptyList());
                }
                if (!(entry.getValue() instanceof SortableBucket)) {
                    throw new ClassCastException();
                }
                SortableBucket sb = (SortableBucket)entry.getValue();
                return this.retrieveExternal(handler, (SortableBucket<byte[]>)sb, finalPattern, sortOptions);
            });
        }
        if (!getObjectsPatterns.isEmpty()) {
            CompletionStage<List<byte[]>> resultingList = sortedCollection.thenCompose(collection -> this.retrieveExternal(handler, (List<ScoredValue<byte[]>>)collection, (Collection<String>)getObjectsPatterns));
            if (destination != null) {
                return this.storeV(handler, ctx, destination, resultingList);
            }
            return handler.stageToReturn(resultingList, ctx, Resp3Response.ARRAY_BULK_STRING);
        }
        if (destination != null) {
            return this.store(handler, ctx, destination, sortedCollection);
        }
        CompletionStage<Collection> cs = sortedCollection.thenApply(res -> res.stream().map(ScoredValue::getValue).toList());
        return handler.stageToReturn(cs, ctx, Resp3Response.ARRAY_BULK_STRING);
    }

    private static byte[] computePatternKey(String pattern, int index, byte[] value) {
        String computedKey = pattern.substring(0, index) + Util.ascii(value) + pattern.substring(index + 1);
        return computedKey.getBytes(StandardCharsets.US_ASCII);
    }

    private CompletionStage<RespRequestHandler> storeV(Resp3Handler handler, ChannelHandlerContext ctx, byte[] destination, CompletionStage<List<byte[]>> resultingList) {
        EmbeddedMultimapListCache<byte[], byte[]> listMultimap = handler.getListMultimap();
        CompletionStage cs = resultingList.thenCompose(values -> listMultimap.replace((Object)destination, values));
        return handler.stageToReturn(cs, ctx, Resp3Response.INTEGER);
    }

    private CompletionStage<RespRequestHandler> store(Resp3Handler handler, ChannelHandlerContext ctx, byte[] destination, CompletionStage<List<ScoredValue<byte[]>>> sortedList) {
        EmbeddedMultimapListCache<byte[], byte[]> listMultimap = handler.getListMultimap();
        CompletionStage cs = sortedList.thenCompose(values -> listMultimap.replace((Object)destination, values.stream().map(ScoredValue::getValue).collect(Collectors.toList())));
        return handler.stageToReturn(cs, ctx, Resp3Response.INTEGER);
    }

    private CompletionStage<List<ScoredValue<byte[]>>> retrieveExternal(Resp3Handler handler, SortableBucket<byte[]> bucket, String pattern, SortableBucket.SortOptions sortOptions) {
        int index = pattern.indexOf(42);
        CompletionStage cs = CompletionStages.performSequentially(bucket.stream().iterator(), wv -> this.readScoredValue(handler, (MultimapObjectWrapper<byte[]>)wv, pattern, index), Collectors.toList());
        return cs.thenApply(list -> bucket.sort(list.stream(), sortOptions));
    }

    private CompletionStage<ScoredValue<byte[]>> readScoredValue(Resp3Handler handler, MultimapObjectWrapper<byte[]> obj, String pattern, int index) {
        CompletionStage<byte[]> cs = this.getEntryValue(handler, pattern, index, (byte[])obj.get());
        return cs.thenApply(w -> {
            if (w == null) {
                return new ScoredValue(Double.valueOf(1.0), obj);
            }
            MultimapObjectWrapper wrappedWeight = new MultimapObjectWrapper(w);
            return new ScoredValue(wrappedWeight.asDouble(), obj);
        });
    }

    private CompletionStage<List<byte[]>> retrieveExternal(Resp3Handler handler, List<ScoredValue<byte[]>> collection, Collection<String> patterns) {
        CompletionStage cs = CompletionStages.performSequentially(patterns.iterator(), pattern -> {
            if (pattern.equals(VALUE_PATTERN)) {
                return CompletableFuture.completedFuture(collection.stream().map(ScoredValue::getValue).toList());
            }
            int index = pattern.indexOf(42);
            if (index < 0) {
                return CompletableFuture.completedFuture(Stream.generate(() -> null).limit(collection.size()).toList());
            }
            return CompletionStages.performSequentially(collection.iterator(), s -> this.getEntryValue(handler, (String)pattern, index, (byte[])s.getValue()), Collectors.toList());
        }, Collectors.toList());
        return cs.thenApply(patternGetResults -> {
            if (patternGetResults.isEmpty()) {
                return Collections.emptyList();
            }
            int size = ((List)patternGetResults.get(0)).size();
            ArrayList<byte[]> finalResult = new ArrayList<byte[]>(patternGetResults.size() * size);
            for (int i = 0; i < size; ++i) {
                for (List current : patternGetResults) {
                    finalResult.add((byte[])current.get(i));
                }
            }
            return finalResult;
        });
    }

    private CompletionStage<byte[]> getEntryValue(Resp3Handler handler, String pattern, int index, byte[] replacement) {
        if (pattern.contains(HASH_FIELD)) {
            String[] split = pattern.split(HASH_FIELD);
            byte[] hashKey = SORT.computePatternKey(split[0], index, replacement);
            byte[] hashField = split[1].getBytes(StandardCharsets.US_ASCII);
            EmbeddedMultimapPairCache<byte[], byte[], byte[]> hash = handler.getHashMapMultimap();
            return hash.get((Object)hashKey, (Object)hashField);
        }
        try {
            AdvancedCache<byte[], byte[]> cache = handler.cache();
            return cache.getAsync((Object)SORT.computePatternKey(pattern, index, replacement)).handle((v, t) -> {
                if (t != null) {
                    if ((t = CompletableFutures.extractException((Throwable)t)) instanceof ClassCastException) {
                        return null;
                    }
                    throw CompletableFutures.asCompletionException((Throwable)t);
                }
                if (!(v instanceof byte[])) {
                    return null;
                }
                byte[] bytes = (byte[])v;
                return bytes;
            });
        }
        catch (ClassCastException ignore) {
            return CompletableFutures.completedNull();
        }
    }

    public static enum Arg {
        ALPHA,
        ASC,
        DESC,
        LIMIT,
        STORE,
        BY,
        GET;

    }
}

