/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import org.infinispan.server.resp.Intrinsics;
import org.infinispan.server.resp.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class BaseRespDecoder
extends ByteToMessageDecoder {
    protected static final Log log = (Log)LogFactory.getLog(BaseRespDecoder.class, Log.class);
    protected final Intrinsics.Resp2LongProcessor longProcessor = new Intrinsics.Resp2LongProcessor();
    protected ChannelHandlerContext ctx;

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        this.ctx = ctx;
    }

    public void resumeRead() {
        if (this.internalBuffer().isReadable() && this.ctx.channel().config().isAutoRead()) {
            this.ctx.channel().eventLoop().submit(() -> {
                try {
                    this.channelRead(this.ctx, Unpooled.EMPTY_BUFFER);
                    this.channelReadComplete(this.ctx);
                }
                catch (Throwable t) {
                    this.ctx.fireExceptionCaught(t);
                }
            });
        }
    }
}

