/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.filter;

import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.GlobUtils;
import org.infinispan.commons.util.Util;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoName;

@ProtoName(value="GlobMatchFilterConverter")
public class GlobMatchFilterConverter<K, V>
extends AbstractKeyValueFilterConverter<byte[], V, byte[]> {
    @ProtoField(number=1)
    final String glob;
    @ProtoField(number=2, defaultValue="false")
    final boolean returnValue;
    private final transient Pattern pattern;

    @ProtoFactory
    GlobMatchFilterConverter(String glob, boolean returnValue) {
        this.glob = glob;
        this.returnValue = returnValue;
        this.pattern = Pattern.compile(GlobUtils.globToRegex((String)glob));
    }

    public MediaType format() {
        return null;
    }

    public byte[] filterAndConvert(byte[] key, V value, Metadata metadata) {
        String k = new String(key, StandardCharsets.UTF_8);
        if (this.pattern.matcher(k).matches()) {
            return this.returnValue ? (byte[])value : Util.EMPTY_BYTE_ARRAY;
        }
        return null;
    }
}

