/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.server.resp.ExternalizerIds;

@Scope(value=Scopes.NONE)
public class EventListenerConverter<K, V, C>
implements CacheEventConverter<K, V, C> {
    public static AdvancedExternalizer<EventListenerConverter> EXTERNALIZER = new Externalizer();
    private DataConversion dc;

    public EventListenerConverter(DataConversion dc) {
        this.dc = dc;
    }

    @Inject
    public void doWiring(ComponentRegistry registry) {
        registry.wireDependencies((Object)this.dc);
    }

    public C convert(K key, V oldValue, Metadata oldMetadata, V newValue, Metadata newMetadata, EventType eventType) {
        return (C)this.dc.fromStorage(newValue);
    }

    public MediaType format() {
        return MediaType.APPLICATION_OCTET_STREAM;
    }

    private static class Externalizer
    extends AbstractExternalizer<EventListenerConverter> {
        private Externalizer() {
        }

        public Set<Class<? extends EventListenerConverter>> getTypeClasses() {
            return Collections.singleton(EventListenerConverter.class);
        }

        public void writeObject(ObjectOutput output, EventListenerConverter object) throws IOException {
            output.writeObject(object.dc);
        }

        public EventListenerConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new EventListenerConverter((DataConversion)input.readObject());
        }

        public Integer getId() {
            return ExternalizerIds.EVENT_LISTENER_CONVERTER;
        }
    }
}

