/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.string;

import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.server.resp.ByteBufferUtils;
import org.infinispan.server.resp.Consumers;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.logging.Log;

public class MSETNX
extends RespCommand
implements Resp3Command {
    public MSETNX() {
        super(-3, 1, -1, 2);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        if (arguments.size() < 2 || arguments.size() % 2 != 0) {
            ByteBufferUtils.stringToByteBuf("-ERR wrong number of arguments for 'msetnx' command\r\n", handler.allocator());
            return handler.myStage();
        }
        Log.SERVER.msetnxConsistencyMessage();
        HashMap<byte[], byte[]> entries = new HashMap<byte[], byte[]>();
        for (int i = 0; i < arguments.size(); ++i) {
            entries.put(arguments.get(++i), arguments.get(i));
        }
        Map existingEntries = handler.cache().getAll(entries.keySet());
        if (existingEntries.isEmpty()) {
            return handler.stageToReturn(handler.cache().putAllAsync(entries).thenApply(v -> 1L), ctx, Consumers.LONG_BICONSUMER);
        }
        return handler.stageToReturn(CompletableFuture.completedFuture(0L), ctx, Consumers.LONG_BICONSUMER);
    }
}

