/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.connection;

import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.server.resp.ByteBufferUtils;
import org.infinispan.server.resp.Consumers;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;

public class MEMORY
extends RespCommand
implements Resp3Command {
    public MEMORY() {
        super(-2, 0, 0, 0);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        String subcommand;
        handler.checkPermission(AuthorizationPermission.ADMIN);
        switch (subcommand = new String(arguments.get(0), StandardCharsets.US_ASCII).toUpperCase()) {
            case "STATS": {
                StringBuilder sb = new StringBuilder();
                sb.append("*54\r\n");
                this.addStat(sb, "peak.allocated", 0);
                this.addStat(sb, "total.allocated", 0);
                this.addStat(sb, "startup.allocated", 0);
                this.addStat(sb, "replication.backlog", 0);
                this.addStat(sb, "clients.slaves", 0);
                this.addStat(sb, "clients.normal", 0);
                this.addStat(sb, "cluster.links", 0);
                this.addStat(sb, "aof.buffer", 0);
                this.addStat(sb, "lua.caches", 0);
                this.addStat(sb, "functions.caches", 0);
                this.addStat(sb, "overhead.total", 0);
                this.addStat(sb, "keys.count", 0);
                this.addStat(sb, "keys.bytes-per-key", 0);
                this.addStat(sb, "dataset.bytes", 0);
                this.addStat(sb, "dataset.percentage", "0.0");
                this.addStat(sb, "peak.percentage", "0.0");
                this.addStat(sb, "allocator.allocated", 0);
                this.addStat(sb, "allocator.active", 0);
                this.addStat(sb, "allocator.resident", 0);
                this.addStat(sb, "allocator-fragmentation.ratio", "0.0");
                this.addStat(sb, "allocator-fragmentation.bytes", 0);
                this.addStat(sb, "allocator-rss.ratio", "0.0");
                this.addStat(sb, "allocator-rss.bytes", 0);
                this.addStat(sb, "rss-overhead.ratio", "0.0");
                this.addStat(sb, "rss-overhead.bytes", 0);
                this.addStat(sb, "fragmentation", "0.0");
                this.addStat(sb, "fragmentation.bytes", 0);
                ByteBufferUtils.stringToByteBufAscii(sb, handler.allocator());
                break;
            }
            case "USAGE": {
                if (arguments.size() < 2) {
                    RespErrorUtil.wrongArgumentCount(this, handler.allocator());
                    return handler.myStage();
                }
                byte[] key = arguments.get(1);
                return handler.stageToReturn(handler.cache().getAsync((Object)key).thenApply(v -> v == null ? null : Long.valueOf((long)(key.length + ((byte[])v).length + 14) / 8L * 8L)), ctx, Consumers.LONG_BICONSUMER);
            }
            case "DOCTOR": 
            case "MALLOC-STATS": 
            case "PURGE": {
                ByteBufferUtils.stringToByteBufAscii("-ERR module loading/unloading unsupported\r\n", handler.allocator());
            }
        }
        return handler.myStage();
    }

    private void addStat(StringBuilder sb, String s, int i) {
        sb.append('$');
        sb.append(s.length());
        sb.append("\r\n");
        sb.append(s);
        sb.append("\r\n");
        sb.append(':');
        sb.append(i);
        sb.append("\r\n");
    }

    private void addStat(StringBuilder sb, String s, String v) {
        sb.append('$');
        sb.append(s.length());
        sb.append("\r\n");
        sb.append(s);
        sb.append("\r\n");
        sb.append('$');
        sb.append(v.length());
        sb.append("\r\n");
        sb.append(v);
        sb.append("\r\n");
    }
}

