/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.nio.charset.StandardCharsets;
import org.infinispan.server.resp.ByteBufferUtils;

public final class ArgumentUtils {
    private ArgumentUtils() {
    }

    public static String toNumberString(byte[] argument) {
        return new String(argument, CharsetUtil.US_ASCII);
    }

    public static double toDouble(byte[] argument, int offset) {
        if (argument == null || argument.length == 0) {
            throw new NumberFormatException("Empty argument");
        }
        return Double.parseDouble(new String(argument, offset, argument.length - offset, CharsetUtil.US_ASCII));
    }

    public static double toDouble(byte[] argument) {
        if (argument == null || argument.length == 0) {
            throw new NumberFormatException("Empty argument");
        }
        return Double.parseDouble(ArgumentUtils.toNumberString(argument));
    }

    public static long toLong(byte[] argument) {
        byte b;
        if (argument == null || argument.length == 0) {
            throw new NumberFormatException("Empty argument");
        }
        boolean negative = false;
        int i = 0;
        if (argument[0] < 48) {
            if (argument[0] != 45 && argument[0] != 43 || argument.length == 1) {
                throw new NumberFormatException("Invalid character: " + argument[0]);
            }
            negative = true;
            i = 1;
        }
        if ((b = argument[i++]) < 48 || b > 57) {
            throw new NumberFormatException("Invalid character: " + b);
        }
        long result = b - 48;
        while (i < argument.length) {
            b = argument[i];
            if (b < 48 || b > 57) {
                throw new NumberFormatException("Invalid character: " + b);
            }
            result = (result << 3) + (result << 1) + (long)(b - 48);
            ++i;
        }
        return negative ? -result : result;
    }

    public static int toInt(byte[] argument) {
        long v = ArgumentUtils.toLong(argument);
        if (v > Integer.MAX_VALUE || v < Integer.MIN_VALUE) {
            throw new NumberFormatException("Value out of range: " + v);
        }
        return (int)v;
    }

    public static byte[] toByteArray(long value) {
        int size = ByteBufferUtils.stringSize(value);
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])new byte[size]);
        buf.resetWriterIndex();
        ByteBufferUtils.setIntChars(value, size, buf);
        return buf.array();
    }

    public static byte[] toByteArray(Number value) {
        double d = value.doubleValue();
        if (value instanceof Double && Math.rint(d) != d) {
            return Double.toString(d).getBytes(StandardCharsets.US_ASCII);
        }
        return ArgumentUtils.toByteArray(value.longValue());
    }
}

