/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.operation;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.time.TimeService;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.server.resp.Util;
import org.infinispan.server.resp.operation.RespExpiration;
import org.infinispan.server.resp.response.SetResponse;
import org.infinispan.util.concurrent.CompletionStages;

public class SetOperation {
    private static final byte[] GET_BYTES = "GET".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] NX_BYTES = "NX".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] XX_BYTES = "XX".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] KEEP_TTL_BYTES = "KEEPTTL".getBytes(StandardCharsets.US_ASCII);
    private static final CompletionStage<SetResponse> MISSING_ARGUMENTS = CompletableFuture.failedFuture(new IllegalStateException("Missing arguments"));

    public static CompletionStage<SetResponse> performOperation(AdvancedCache<byte[], byte[]> cache, List<byte[]> arguments, TimeService timeService) {
        try {
            if (arguments.size() < 2) {
                return MISSING_ARGUMENTS;
            }
            SetOperationOptions options = new SetOperationOptions(arguments, timeService);
            if (options.operationType == XX_BYTES) {
                return SetOperation.performOperationWithXX(cache, options, timeService);
            }
            CompletionStage cacheOperation = options.isKeepingTtl() ? cache.getCacheEntryAsync((Object)options.key).thenCompose(e -> SetOperation.performOperation(cache, options, e != null ? SetOperation.extractCurrentTTL(e, timeService) : -1L)) : SetOperation.performOperation(cache, options, options.expirationMs);
            if (CompletionStages.isCompletedSuccessfully(cacheOperation)) {
                return CompletableFuture.completedFuture(SetOperation.parseResponse(options, (byte[])CompletionStages.join((CompletionStage)cacheOperation)));
            }
            return cacheOperation.thenApply(v -> SetOperation.parseResponse(options, v));
        }
        catch (Exception e2) {
            return CompletableFuture.failedFuture(e2);
        }
    }

    private static CompletionStage<byte[]> performOperation(AdvancedCache<byte[], byte[]> cache, SetOperationOptions options, long expiration) {
        byte[] key = options.key;
        byte[] value = options.value;
        return options.operationType == null ? cache.putAsync((Object)key, (Object)value, expiration, TimeUnit.MILLISECONDS) : cache.putIfAbsentAsync((Object)key, (Object)value, expiration, TimeUnit.MILLISECONDS);
    }

    private static SetResponse parseResponse(SetOperationOptions options, byte[] v) {
        return options.operationType == null ? new SetResponse(v, options.isReturningPrevious()) : new SetResponse(v, options.isReturningPrevious(), v == null);
    }

    private static CompletionStage<SetResponse> performOperationWithXX(AdvancedCache<byte[], byte[]> cache, SetOperationOptions options, TimeService timeService) {
        byte[] key = options.key;
        byte[] value = options.value;
        return cache.getCacheEntryAsync((Object)key).thenCompose(e -> {
            if (e == null || e.isNull()) {
                return CompletableFuture.completedFuture(new SetResponse(null, options.isReturningPrevious(), false));
            }
            long exp = -1L;
            if (options.isKeepingTtl()) {
                exp = SetOperation.extractCurrentTTL(e, timeService);
            }
            byte[] prev = (byte[])e.getValue();
            return cache.replaceAsync((Object)key, (Object)prev, (Object)value, exp, TimeUnit.MILLISECONDS).thenApply(b -> new SetResponse(prev, options.isReturningPrevious(), (boolean)b));
        });
    }

    private static long extractCurrentTTL(CacheEntry<?, ?> entry, TimeService timeService) {
        long lifespan = entry.getLifespan();
        long delta = timeService.instant().toEpochMilli() - entry.getCreated();
        return lifespan - delta;
    }

    private static class SetOperationOptions {
        private final List<byte[]> arguments;
        private byte[] key;
        private byte[] value;
        private long expirationMs;
        private boolean keepTtl;
        private boolean setAndReturnPrevious;
        private byte[] operationType;

        public SetOperationOptions(List<byte[]> arguments, TimeService timeService) {
            this.arguments = arguments;
            this.key = null;
            this.value = null;
            this.expirationMs = -1L;
            this.keepTtl = false;
            this.setAndReturnPrevious = false;
            this.operationType = null;
            this.parseAndLoadOptions(timeService);
        }

        public void withKey(byte[] key) {
            this.key = key;
        }

        public void withValue(byte[] value) {
            this.value = value;
        }

        public void withReturnPrevious() {
            this.setAndReturnPrevious = true;
        }

        public void withExpiration(long expirationMs) {
            this.expirationMs = expirationMs;
        }

        public void withOperationType(byte[] operationType) {
            this.operationType = operationType;
        }

        public void withKeepTtl() {
            this.keepTtl = true;
        }

        public boolean isKeepingTtl() {
            return this.keepTtl;
        }

        public boolean isReturningPrevious() {
            return this.setAndReturnPrevious;
        }

        public boolean isUsingExpiration() {
            return this.expirationMs > 0L || this.isKeepingTtl();
        }

        /*
         * Enabled aggressive block sorting
         */
        private void parseAndLoadOptions(TimeService timeService) {
            this.withKey(this.arguments.get(0));
            this.withValue(this.arguments.get(1));
            int i = 2;
            while (true) {
                block18: {
                    byte[] arg;
                    block17: {
                        if (i >= this.arguments.size()) {
                            return;
                        }
                        arg = this.arguments.get(i);
                        if (arg.length != 2 && arg.length != 4) break block17;
                        switch (arg[0]) {
                            case 78: 
                            case 110: {
                                if (!Util.caseInsensitiveAsciiCheck('X', arg[1])) break;
                                if (this.operationType != null) {
                                    throw new IllegalArgumentException("NX and XX options are mutually exclusive");
                                }
                                this.withOperationType(NX_BYTES);
                                break block18;
                            }
                            case 88: 
                            case 120: {
                                if (!Util.caseInsensitiveAsciiCheck('X', arg[1])) break;
                                if (this.operationType != null) {
                                    throw new IllegalArgumentException("NX and XX options are mutually exclusive");
                                }
                                this.withOperationType(XX_BYTES);
                                break block18;
                            }
                            case 69: 
                            case 80: 
                            case 101: 
                            case 112: {
                                RespExpiration expiration = RespExpiration.valueOf(arg);
                                if (this.isUsingExpiration()) {
                                    throw new IllegalArgumentException("Only one expiration option should be used on SET");
                                }
                                if (this.isKeepingTtl()) {
                                    throw new IllegalArgumentException("KEEPTTL and EX/PX/EXAT/PXAT are mutually exclusive");
                                }
                                if (i + 1 > this.arguments.size()) {
                                    throw new IllegalArgumentException("No argument accompanying expiration");
                                }
                                this.withExpiration(expiration.convert(Long.parseLong(new String(this.arguments.get(i + 1), StandardCharsets.US_ASCII)), timeService));
                                ++i;
                                break block18;
                            }
                        }
                        throw new IllegalArgumentException("Unknown argument for SET operation");
                    }
                    if (arg.length == 3 && Util.isAsciiBytesEquals(GET_BYTES, arg)) {
                        this.withReturnPrevious();
                    } else if (arg.length == 7 && Util.isAsciiBytesEquals(KEEP_TTL_BYTES, arg)) {
                        if (this.isUsingExpiration()) {
                            throw new IllegalArgumentException("KEEPTTL and EX/PX/EXAT/PXAT are mutually exclusive");
                        }
                        this.withKeepTtl();
                    } else {
                        throw new IllegalArgumentException("Unknown argument for SET operation");
                    }
                }
                ++i;
            }
        }
    }
}

