/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.generic;

import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.server.resp.Consumers;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.Util;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;

public class EXPIRE
extends RespCommand
implements Resp3Command {
    public static final CompletableFuture<Long> NOT_APPLIED = CompletableFuture.completedFuture(0L);
    public static final CompletableFuture<Long> APPLIED = CompletableFuture.completedFuture(1L);
    private final boolean unixTime;

    public EXPIRE() {
        this(false);
    }

    protected EXPIRE(boolean at) {
        super(-3, 1, 1, 1);
        this.unixTime = at;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        byte[] key = arguments.get(0);
        long expiration = ArgumentUtils.toLong(arguments.get(1));
        Mode mode = Mode.NONE;
        if (arguments.size() == 3) {
            mode = Mode.valueOf(new String(arguments.get(2), StandardCharsets.US_ASCII).toUpperCase());
        }
        return handler.stageToReturn(EXPIRE.expire(handler, key, expiration, mode, this.unixTime), ctx, Consumers.LONG_BICONSUMER);
    }

    private static CompletionStage<Long> expire(Resp3Handler handler, byte[] key, long expiration, Mode mode, boolean unixTime) {
        MediaType vmt = handler.cache().getValueDataConversion().getStorageMediaType();
        AdvancedCache acm = handler.cache().withMediaType(MediaType.APPLICATION_OCTET_STREAM, vmt);
        return acm.getCacheEntryAsync((Object)key).thenCompose(e -> {
            if (e == null) {
                return NOT_APPLIED;
            }
            long ttl = e.getLifespan();
            if (unixTime) {
                ttl = Util.toUnixTime(ttl, handler.respServer().getTimeService());
            } else if (ttl >= 0L) {
                ttl = TimeUnit.MILLISECONDS.toSeconds(e.getLifespan());
            }
            switch (mode.ordinal()) {
                case 1: {
                    if (ttl < 0L) break;
                    return NOT_APPLIED;
                }
                case 2: {
                    if (ttl >= 0L) break;
                    return NOT_APPLIED;
                }
                case 3: {
                    if (expiration >= ttl) break;
                    return NOT_APPLIED;
                }
                case 4: {
                    if (expiration <= ttl) break;
                    return NOT_APPLIED;
                }
            }
            CompletableFuture replace = unixTime ? acm.replaceAsync((Object)((byte[])e.getKey()), e.getValue(), e.getValue(), Util.fromUnixTime(expiration, handler.respServer().getTimeService()), TimeUnit.MILLISECONDS) : acm.replaceAsync((Object)((byte[])e.getKey()), e.getValue(), e.getValue(), expiration, TimeUnit.SECONDS);
            return replace.thenCompose(b -> {
                if (b.booleanValue()) {
                    return APPLIED;
                }
                return EXPIRE.expire(handler, key, expiration, mode, unixTime);
            });
        });
    }

    static enum Mode {
        NONE,
        NX,
        XX,
        GT,
        LT;

    }
}

