/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.CharsetUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.Version;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.resp.Authenticator;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.CacheRespRequestHandler;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.configuration.RespServerConfiguration;

public class Resp3AuthHandler
extends CacheRespRequestHandler {
    public Resp3AuthHandler(RespServer server) {
        super(server);
    }

    @Override
    protected CompletionStage<RespRequestHandler> actualHandleRequest(ChannelHandlerContext ctx, RespCommand type, List<byte[]> arguments) {
        CompletionStage<Boolean> successStage = null;
        switch (type) {
            case HELLO: {
                byte[] respProtocolBytes = arguments.get(0);
                String version = new String(respProtocolBytes, CharsetUtil.UTF_8);
                if (!version.equals("3")) {
                    Resp3AuthHandler.stringToByteBuf("-NOPROTO sorry this protocol version is not supported\r\n", this.allocatorToUse);
                    break;
                }
                if (arguments.size() == 4) {
                    successStage = this.performAuth(ctx, arguments.get(2), arguments.get(3));
                    break;
                }
                Resp3AuthHandler.helloResponse(ctx, this.allocatorToUse);
                break;
            }
            case AUTH: {
                successStage = this.performAuth(ctx, arguments.get(0), arguments.get(1));
                break;
            }
            case QUIT: {
                ctx.close();
                break;
            }
            default: {
                if (this.isAuthorized()) {
                    super.actualHandleRequest(ctx, type, arguments);
                    break;
                }
                this.handleUnauthorized(ctx);
            }
        }
        if (successStage != null) {
            return this.stageToReturn(successStage, ctx, (E auth) -> auth != false ? this.respServer.newHandler() : this);
        }
        return this.myStage;
    }

    private CompletionStage<Boolean> performAuth(ChannelHandlerContext ctx, byte[] username, byte[] password) {
        return this.performAuth(ctx, new String(username, StandardCharsets.UTF_8), new String(password, StandardCharsets.UTF_8));
    }

    private CompletionStage<Boolean> performAuth(ChannelHandlerContext ctx, String username, String password) {
        Authenticator authenticator = ((RespServerConfiguration)this.respServer.getConfiguration()).authentication().authenticator();
        if (authenticator == null) {
            return CompletableFutures.booleanStage((boolean)this.handleAuthResponse(ctx, null));
        }
        return authenticator.authenticate(username, password.toCharArray()).thenApplyAsync(r -> this.handleAuthResponse(ctx, (Subject)r), (Executor)ctx.channel().eventLoop()).exceptionally(t -> {
            this.handleUnauthorized(ctx);
            return false;
        });
    }

    private boolean handleAuthResponse(ChannelHandlerContext ctx, Subject subject) {
        assert (ctx.channel().eventLoop().inEventLoop());
        if (subject == null) {
            Resp3AuthHandler.stringToByteBuf("-ERR Client sent AUTH, but no password is set\r\n", this.allocatorToUse);
            return false;
        }
        this.setCache((AdvancedCache<byte[], byte[]>)this.cache.withSubject(subject));
        Resp3Handler.OK_BICONSUMER.accept(null, this.allocatorToUse);
        return true;
    }

    private void handleUnauthorized(ChannelHandlerContext ctx) {
        assert (ctx.channel().eventLoop().inEventLoop());
        Resp3AuthHandler.stringToByteBuf("-WRONGPASS invalid username-password pair or user is disabled.\r\n", this.allocatorToUse);
    }

    private boolean isAuthorized() {
        return this.getClass() != Resp3AuthHandler.class;
    }

    private static void helloResponse(ChannelHandlerContext ctx, ByteBufPool alloc) {
        String versionString = Version.getBrandVersion();
        RespRequestHandler.stringToByteBuf("%7\r\n$6\r\nserver\r\n$15\r\nInfinispan RESP\r\n$7\r\nversion\r\n$" + versionString.length() + "\r\n" + versionString + "\r\n$5\r\nproto\r\n:3\r\n$2\r\nid\r\n:184\r\n$4\r\nmode\r\n$7\r\ncluster\r\n$4\r\nrole\r\n$6\r\nmaster\r\n$7\r\nmodules\r\n*0\r\n", alloc);
    }
}

