/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.Util;
import org.infinispan.server.resp.Intrinsics;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespDecoder;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.logging.Log;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.LogFactory;

public abstract class BaseRespDecoder
extends ByteToMessageDecoder {
    protected static final Log log = (Log)LogFactory.getLog(RespDecoder.class, Log.class);
    protected static final int MINIMUM_BUFFER_SIZE = Integer.parseInt(System.getProperty("infinispan.resp.minimum-buffer-size", "4096"));
    protected final Intrinsics.Resp2LongProcessor longProcessor = new Intrinsics.Resp2LongProcessor();
    protected RespRequestHandler requestHandler;
    protected ByteBuf outboundBuffer;
    protected boolean resumeAutoReadOnWritability;

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, int size) {
        if (this.outboundBuffer != null) {
            if (this.outboundBuffer.writableBytes() > size) {
                return this.outboundBuffer;
            }
            log.tracef("Writing buffer %s as request is larger than remaining", this.outboundBuffer);
            ctx.write((Object)this.outboundBuffer, ctx.voidPromise());
        }
        int allocatedSize = Math.max(size, MINIMUM_BUFFER_SIZE);
        this.outboundBuffer = ctx.alloc().buffer(allocatedSize, allocatedSize);
        return this.outboundBuffer;
    }

    private void flushBufferIfNeeded(ChannelHandlerContext ctx, boolean runOnEventLoop) {
        if (this.outboundBuffer != null) {
            log.tracef("Writing and flushing buffer %s", this.outboundBuffer);
            if (runOnEventLoop) {
                ctx.channel().eventLoop().execute(() -> {
                    ctx.writeAndFlush((Object)this.outboundBuffer, ctx.voidPromise());
                    this.outboundBuffer = null;
                });
            } else {
                ctx.writeAndFlush((Object)this.outboundBuffer, ctx.voidPromise());
                this.outboundBuffer = null;
            }
        }
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().attr(RespRequestHandler.BYTE_BUF_POOL_ATTRIBUTE_KEY).set(size -> this.allocateBuffer(ctx, size));
        super.channelRegistered(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        super.channelUnregistered(ctx);
        this.requestHandler.handleChannelDisconnect(ctx);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().config().isAutoRead()) {
            this.flushBufferIfNeeded(ctx, false);
        }
        super.channelReadComplete(ctx);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (this.resumeAutoReadOnWritability && ctx.channel().isWritable()) {
            this.resumeAutoReadOnWritability = false;
            ctx.channel().eventLoop().execute(() -> this.attemptReadResume(ctx));
        }
        super.channelWritabilityChanged(ctx);
    }

    protected void attemptReadResume(ChannelHandlerContext ctx) {
        log.tracef("Re-enabling auto read for channel %s as previous command is complete", ctx.channel());
        ctx.channel().config().setAutoRead(true);
        ByteBuf buf = this.internalBuffer();
        if (buf.isReadable()) {
            log.tracef("Bytes available from previous read for channel %s, trying decode directly", ctx.channel());
            this.callDecode(ctx, buf, List.of());
            if (ctx.channel().config().isAutoRead()) {
                this.flushBufferIfNeeded(ctx, false);
            }
        }
    }

    protected boolean handleCommandAndArguments(ChannelHandlerContext ctx, RespCommand command, List<byte[]> arguments) {
        CompletionStage<RespRequestHandler> stage;
        if (log.isTraceEnabled()) {
            log.tracef("Received command: %s with arguments %s for %s", (Object)command, Util.toStr(arguments), ctx.channel());
        }
        if (CompletionStages.isCompletedSuccessfully(stage = this.requestHandler.handleRequest(ctx, command, arguments))) {
            this.requestHandler = (RespRequestHandler)CompletionStages.join(stage);
            if (this.outboundBuffer != null && (long)this.outboundBuffer.readableBytes() > ctx.channel().bytesBeforeUnwritable()) {
                log.tracef("Buffer will cause channel %s to be unwriteable - forcing flush", ctx.channel());
                this.flushBufferIfNeeded(ctx, true);
                ctx.channel().config().setAutoRead(false);
                this.resumeAutoReadOnWritability = true;
                return false;
            }
            return true;
        }
        log.tracef("Disabling auto read for channel %s until previous command is complete", ctx.channel());
        ctx.channel().config().setAutoRead(false);
        stage.whenComplete((handler, t) -> {
            assert (ctx.channel().eventLoop().inEventLoop());
            if (t != null) {
                this.exceptionCaught(ctx, (Throwable)t);
                return;
            }
            this.requestHandler = handler;
            this.flushBufferIfNeeded(ctx, false);
            ctx.channel().eventLoop().execute(() -> this.attemptReadResume(ctx));
        });
        return false;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.unexpectedException(cause);
        RespRequestHandler.stringToByteBuf("-ERR Server Error Encountered: " + cause.getMessage() + "\\r\\n", this.requestHandler.allocatorToUse);
        this.flushBufferIfNeeded(ctx, false);
        ctx.close();
    }
}

