/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.Channel;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import javax.security.auth.Subject;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.server.hotrod.BaseRequestProcessor;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.util.logging.LogFactory;

class MultimapRequestProcessor
extends BaseRequestProcessor {
    private static final Log log = (Log)LogFactory.getLog(MultimapRequestProcessor.class, Log.class);

    MultimapRequestProcessor(Channel channel, Executor executor, HotRodServer server) {
        super(channel, executor, server);
    }

    void get(HotRodHeader header, Subject subject, byte[] key, boolean supportsDuplicates) {
        if (log.isTraceEnabled()) {
            log.trace("Call get");
        }
        this.server.multimap(header, subject, supportsDuplicates).get((Object)key).whenComplete((result, throwable) -> this.handleGet(header, (Collection<byte[]>)result, (Throwable)throwable));
    }

    private void handleGet(HotRodHeader header, Collection<byte[]> result, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else {
            try {
                OperationStatus status = OperationStatus.Success;
                if (result.isEmpty()) {
                    this.writeNotExist(header);
                    return;
                }
                this.writeResponse(header, header.encoder().multimapCollectionResponse(header, this.server, this.channel, status, result));
            }
            catch (Throwable t2) {
                this.writeException(header, t2);
            }
        }
    }

    void getWithMetadata(HotRodHeader header, Subject subject, byte[] key, boolean supportsDuplicates) {
        if (log.isTraceEnabled()) {
            log.trace("Call getWithMetadata");
        }
        this.server.multimap(header, subject, supportsDuplicates).getEntry((Object)key).whenComplete((entry, throwable) -> this.handleGetWithMetadata(header, (Optional<CacheEntry<byte[], Collection<byte[]>>>)entry, (Throwable)throwable));
    }

    private void handleGetWithMetadata(HotRodHeader header, Optional<CacheEntry<byte[], Collection<byte[]>>> entry, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else {
            try {
                if (!entry.isPresent()) {
                    this.writeNotExist(header);
                    return;
                }
                OperationStatus status = OperationStatus.Success;
                CacheEntry<byte[], Collection<byte[]>> ce = entry.get();
                this.writeResponse(header, header.encoder().multimapEntryResponse(header, this.server, this.channel, status, ce));
            }
            catch (Throwable t2) {
                this.writeException(header, t2);
            }
        }
    }

    void put(HotRodHeader header, Subject subject, byte[] key, byte[] value, boolean supportsDuplicates) {
        if (log.isTraceEnabled()) {
            log.trace("Call put");
        }
        this.server.multimap(header, subject, supportsDuplicates).put((Object)key, (Object)value).whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.writeException(header, (Throwable)throwable);
            } else {
                this.writeResponse(header, header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.Success));
            }
        });
    }

    void removeKey(HotRodHeader header, Subject subject, byte[] key, boolean supportsDuplicates) {
        if (log.isTraceEnabled()) {
            log.trace("Call removeKey");
        }
        this.server.multimap(header, subject, supportsDuplicates).remove((Object)key).whenComplete(this.handleBoolean(header));
    }

    void removeEntry(HotRodHeader header, Subject subject, byte[] key, byte[] value, boolean supportsDuplicates) {
        log.trace("Call removeEntry");
        this.server.multimap(header, subject, supportsDuplicates).remove((Object)key, (Object)value).whenComplete(this.handleBoolean(header));
    }

    void size(HotRodHeader header, Subject subject, boolean supportsDuplicates) {
        log.trace("Call size");
        this.server.multimap(header, subject, supportsDuplicates).size().whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.writeException(header, (Throwable)throwable);
            } else {
                this.writeResponse(header, header.encoder().unsignedLongResponse(header, this.server, this.channel, (long)result));
            }
        });
    }

    void containsEntry(HotRodHeader header, Subject subject, byte[] key, byte[] value, boolean supportsDuplicates) {
        log.trace("Call containsEntry");
        this.server.multimap(header, subject, supportsDuplicates).containsEntry((Object)key, (Object)value).whenComplete(this.handleBoolean(header));
    }

    void containsKey(HotRodHeader header, Subject subject, byte[] key, boolean supportsDuplicates) {
        log.trace("Call containsKey");
        this.server.multimap(header, subject, supportsDuplicates).containsKey((Object)key).whenComplete(this.handleBoolean(header));
    }

    void containsValue(HotRodHeader header, Subject subject, byte[] value, boolean supportsDuplicates) {
        log.trace("Call containsValue");
        this.server.multimap(header, subject, supportsDuplicates).containsValue((Object)value).whenComplete(this.handleBoolean(header));
    }

    private BiConsumer<Boolean, Throwable> handleBoolean(HotRodHeader header) {
        return (result, throwable) -> {
            if (throwable != null) {
                this.writeException(header, (Throwable)throwable);
            } else {
                this.writeResponse(header, header.encoder().booleanResponse(header, this.server, this.channel, (boolean)result));
            }
        };
    }
}

