/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.impl.ScriptingManagerImpl;

public final class ScriptingInterceptor
extends BaseCustomAsyncInterceptor {
    private ScriptingManagerImpl scriptingManager;

    @Inject
    public void init(ScriptingManager scriptingManager) {
        this.scriptingManager = (ScriptingManagerImpl)scriptingManager;
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        String name = (String)command.getKey();
        String script = (String)command.getValue();
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, this.scriptingManager.compileScript(name, script).thenAccept(arg_0 -> ((PutKeyValueCommand)command).setMetadata(arg_0)));
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        this.scriptingManager.compiledScripts.clear();
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        this.scriptingManager.compiledScripts.remove(command.getKey());
        return this.invokeNext(ctx, (VisitableCommand)command);
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        String name = (String)command.getKey();
        String script = (String)command.getNewValue();
        return this.asyncInvokeNext(ctx, (VisitableCommand)command, this.scriptingManager.compileScript(name, script).thenAccept(arg_0 -> ((ReplaceCommand)command).setMetadata(arg_0)));
    }
}

