/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.mapping.reference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.infinispan.api.annotations.indexing.option.Structure;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.query.remote.impl.indexing.FieldMapping;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.mapping.reference.FieldReferenceProvider;

public class MessageReferenceProvider {
    public static final Set<String> COMMON_MESSAGE_TYPES = new HashSet<String>(Arrays.asList(FieldReferenceProvider.COMMON_MESSAGE_TYPES));
    private final List<FieldReferenceProvider> fields;
    private final List<Embedded> embedded;

    public MessageReferenceProvider(Descriptor descriptor) {
        this.fields = new ArrayList<FieldReferenceProvider>(descriptor.getFields().size());
        this.embedded = new ArrayList<Embedded>();
        IndexingMetadata indexingMetadata = (IndexingMetadata)IndexingMetadata.findProcessedAnnotation(descriptor, "Indexed");
        if (indexingMetadata == null) {
            return;
        }
        for (FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            String fieldName = fieldDescriptor.getName();
            FieldMapping fieldMapping = indexingMetadata.getFieldMapping(fieldName);
            if (fieldMapping == null) continue;
            if (Type.MESSAGE.equals((Object)fieldDescriptor.getType()) && !COMMON_MESSAGE_TYPES.contains(fieldDescriptor.getTypeName())) {
                if (!fieldMapping.searchable() || !this.isIndexable(fieldDescriptor.getMessageType())) continue;
                this.embedded.add(new Embedded(fieldName, fieldDescriptor.getMessageType().getFullName(), fieldDescriptor.isRepeated(), fieldMapping));
                continue;
            }
            FieldReferenceProvider fieldReferenceProvider = new FieldReferenceProvider(fieldDescriptor, fieldMapping);
            if (fieldReferenceProvider.nothingToBind()) continue;
            this.fields.add(fieldReferenceProvider);
        }
    }

    private boolean isIndexable(Descriptor descriptor) {
        IndexingMetadata indexingMetadata = (IndexingMetadata)IndexingMetadata.findProcessedAnnotation(descriptor, "Indexed");
        if (indexingMetadata == null) {
            return false;
        }
        for (FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            FieldMapping fieldMapping = indexingMetadata.getFieldMapping(fieldDescriptor.getName());
            if (fieldMapping == null) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public HashMap<String, IndexFieldReference<?>> bind(IndexSchemaElement indexSchemaElement, String basePath) {
        HashMap result = new HashMap();
        for (FieldReferenceProvider field : this.fields) {
            String newPath = "".equals(basePath) ? field.getName() : basePath + "." + field.getName();
            result.put(newPath, field.bind(indexSchemaElement));
        }
        return result;
    }

    public List<Embedded> getEmbedded() {
        return this.embedded;
    }

    public String toString() {
        return "{fields=" + String.valueOf(this.fields) + ", embedded=" + String.valueOf(this.embedded) + "}";
    }

    public static class Embedded {
        private final String fieldName;
        private final String typeFullName;
        private final boolean repeated;
        private final Integer includeDepth;
        private final ObjectStructure structure;

        public Embedded(String fieldName, String typeFullName, boolean repeated, FieldMapping fieldMapping) {
            this.fieldName = fieldName;
            this.typeFullName = typeFullName;
            this.repeated = repeated;
            this.includeDepth = fieldMapping.includeDepth();
            this.structure = fieldMapping.structure() == null ? null : (Structure.NESTED.equals((Object)fieldMapping.structure()) ? ObjectStructure.NESTED : ObjectStructure.FLATTENED);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getTypeFullName() {
            return this.typeFullName;
        }

        public boolean isRepeated() {
            return this.repeated;
        }

        public Integer getIncludeDepth() {
            return this.includeDepth;
        }

        public ObjectStructure getStructure() {
            return this.structure;
        }

        public String toString() {
            return "{fieldName='" + this.fieldName + "', typeName='" + this.typeFullName + "'}";
        }
    }
}

